$(document).ready(function() {
    $("#pais").on('change', function() {
        var id = $(this).val();
        $.ajax({
            url: r+'funciones/allselect.php' ,
            type: "post",
            data: { 'idpais':id},
            success: function(data){
                $('#departamento').html(data).slideDown(400);
                $('#municipio').html('').slideDown(400);
            }
        })
    });
    $("#departamento").on('change', function() {
        var id = $(this).val();
        $.ajax({
            url: r+'funciones/allselect.php' ,
            type: "post",
            data: { 'iddepa':id},
            success: function(data){
                $('#municipio').html(data).slideDown(400);
            }
        })
    });
    $('a.eliminarcurso').on('click', function(e){
        var URL = $(this).attr("href");
        e.preventDefault();
        Swal.fire({
          title: 'Estas seguro que deseas eliminar este curso?',
          icon: 'error',
          showDenyButton: true,
          showCancelButton: true,
          confirmButtonText: `Eliminar`,
          denyButtonText: `cancelar`,
        }).then((result) => {
          /* Read more about isConfirmed, isDenied below */
          if (result.isConfirmed) {
            window.location.href = URL;
          } else if (result.isDenied) {
            Swal.fire('Changes are not saved', '', 'info')
          }
        });
    });
    $("#formulario*").on('submit', function(e) {
        e.preventDefault();
        $("button").prop('disabled', true); 
        $('#divprocesando').removeClass('d-none');
        var action = $(this).attr('action');
        var type = $(this).attr('method');
        var formData = new FormData(this);
        $.ajax({
            url: action,
            type: type,
            data: formData,
            contentType: false, //this is requireded please see answers above
            processData: false, //this is requireded please see answers above
            success: function(data){
                setTimeout(function(){$('#divprocesando').addClass('d-none');$("button").prop('disabled', false); }, 200);
               var json = JSON.parse(data); // show response from the php script.
               if(json[0].accion.match('modal') !== null){
                   viewmodal(json[0].idmodal,json[0].titlemsg,json[0].msg);
                   if(json[0].idtabl){tableleccion(json[0].idtable,json[0].table);}
                   if(json[0].rtr){removetr(json[0].rtr);}
                   if(json[0].table){uptable(json[0].table);}
               }                   
               else if(json[0].accion.match('alert') !== null){
                   viewalert(json[0].msg,json[0].tipo);
                   if(json[0].idmodal){setTimeout(function(){ $(json[0].idmodal).modal('hide') }, 3000); console.log('idmodal');}
                   if(json[0].idtable){tableleccion(json[0].idtable,json[0].table);console.log('tabeleccon');}
                   if(json[0].rtr){removetr(json[0].rtr);console.log('removertr');}
                   if(json[0].table){uptable(json[0].table);console.log('uptable');}
               }
               else if(json[0].accion.match('before') !== null){
                   $(json[0].element).before(json[0].html);
                   viewmodal(json[0].idmodal,json[0].titlemsg,json[0].msg);
                   $("#formulario*")[0].reset();
                   $("#formulario*").trigger('reset');
               }
               else if(json[0].accion.match('redirect') !== null){
                   window.location.replace(json[0].url);
               }
               $("#formulario*")[0].reset();
               $("#formulario*").removeClass('was-validated');
            },
            error: function (jqXHR, exception) {
                setTimeout(function(){$('#divprocesando').addClass('d-none');$("button").prop('disabled', false); }, 200);
                errores(jqXHR, exception);
            }
        })
    });
    $('.form-control-chosen').chosen();
    $('.chosen-container*').attr('style','width:100%;');
});

function errores(jqXHR, exception){
    var msg = '';
    if (jqXHR.status === 0) {
        msg = '<div class="alert alert-danger" role="alert">Sin conexión.\n Verificar tu conexion a internet</div>';
    } else if (jqXHR.status == 404) {
        msg = '<div class="alert alert-danger" role="alert">Pagina solicitada no encontrada. [404]</div>';
    } else if (jqXHR.status == 500) {
        msg = '<div class="alert alert-danger" role="alert">Error interno del servidor [500].</div>';
    } else if (exception === 'parsererror') {
        msg = '<div class="alert alert-danger" role="alert">Error al analizar JSON solicitado.</div>';
    } else if (exception === 'timeout') {
        msg = '<div class="alert alert-danger" role="alert">Error de tiempo de espera</div>';
    } else if (exception === 'abort') {
        msg = '<div class="alert alert-danger" role="alert">Solicitud Ajax abortada.</div>';
    } else {
        msg = '<div class="alert alert-danger" role="alert">Error no detectado.\n' + jqXHR.responseText+'</div>';
    }
    viewalert(msg,'');
}

function viewmodal(idmodal,title,msg){
    if(idmodal!==''){$(idmodal).modal('hide')}
    $('#titlemodal*').html(title);
    $('#modal-msg*').html(msg);
    $('#ModalMsg*').modal('show');
}
function viewalert(msg,tipoalert){
    $('#alert-msg*').html(msg);
    $('#form-alert*').removeClass('fade');
    $('#form-alert*').removeClass('hide');
    $('#form-alert*').addClass(tipoalert);
    $('#form-alert*').addClass('show');
    setTimeout(function(){
        $('#form-alert*').removeClass('show');
        $('#form-alert*').addClass('fade');
        $('#form-alert*').addClass('hide');
        $('#form-alert*').removeClass(tipoalert);
    }, 7000);
}
function uptable(data){
    var json = JSON.parse(data);
    var table = $('.table').DataTable();
    table.row.add(json).node().id = json[0];
    table.draw();
}
function removetr(id){
    var table = $('.table').DataTable();
    table.rows( id ).remove().draw();
}
function tableleccion(idtable,data){
    $(idtable).append(data);
}