<?php
$r= '../';
require_once($r."inc/config.php");
$mysqli = connectDB($r);
session_start();
$idusuario = $_SESSION['userid'];

// Acciones para los KITS

if(isset($_POST['newkit'])){
    $kit = $_POST['newkit'];
    $idempresa = $_POST['idempresa'];
    
    // Consulta para verificar si el kit ya existe
    $qry_check = $mysqli->query("SELECT COUNT(*) as total FROM `z_productos_kits` WHERE `kit` = '$kit' AND `idempresa` = '$idempresa'");
    $row = $qry_check->fetch_assoc();
    
    if ($row['total'] > 0) {
            $response['success'] = false;
            $response['message'] = 'Error, El nombre "'.$kit.'" ya existe. Por favor, elija uno diferente.'; 
    } else {
        // Inserta el nuevo kit
        $qry1 = $mysqli->query("INSERT INTO `z_productos_kits`(`kit`, `idempresa`) VALUES ('$kit','$idempresa')");
        if ($qry1) {
            $response['success'] = true;
            $response['message'] = 'Exito, La kit se ha creado.'; 
        } else {
            $response['success'] = false;
            $response['message'] = 'Error al registrar el kit.'; 
        }
    }
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}

if(isset($_POST['configkit'])){
    
    $idkit = $_POST['configkit'];
    $qry1 = $mysqli->query("SELECT `id`,`idkit`, `idproducto`, `cantidad`, `seriales`, `nota`, `fecha` FROM `z_productos_kits_elementos` WHERE `idkit`= $idkit");
    
    $response = [];
    $tableHTML = '';
    
    // Generar la cabecera de la tabla
    
    $tableHTML .= '<div class="h3 p-3"><span class="modal-title h5">Información</span><button type="button" class="btn btn-primary float-right m-1" onclick="AddElementKit('.$idkit.')"><i class="fa fa-plus"></i> Agregar Elemento</button>';
    $tableHTML .= '<button type="button" class="btn btn-info float-right m-1" onclick="historialkit('.$idkit.')"><i class="fa fa-history"></i> Historial</button></div>';
    $tableHTML .= '<table id="configkit" class="table table-bordered"><caption><strong>Configurtacion del Kit</strong></caption>';
    $tableHTML .= '<thead>
    <tr>
        <th>Producto</th>
        <th>Cantidad</th>
        <th>Seriales</th>
        <th>Nota</th>
        <th>Fecha</th>
        <th>Acciones</th>
    </tr>
    </thead>
    <tbody>';
    
    // Recorrer todos los registros obtenidos de la consulta
    while ($row1 = $qry1->fetch_assoc()) {
        // Preparar los seriales si existen
        $seriales = $row1['seriales'];
        if (!empty($seriales)) {
            $seriales = str_replace(['[', ']', '"'], " ", $seriales);
        } else {
            $seriales = 'Este producto no cuenta con seriales';
        }
        
        $infoproducto = sinfo($row1['idproducto'],'z_productos');
        // Agregar una fila a la tabla
        $tableHTML .= '<tr>
            <td>' . $infoproducto['producto'] . '</td>
            <td>' . $row1['cantidad'] . '</td>
            <td>' . $seriales . '</td>
            <td>' . $row1['nota'] . '</td>
            <td>' . $row1['fecha'] . '</td>
            <td>
                <button title="Trasladar" class="btn btn-warning btn-sm" onclick="trasladar(' . $idkit . ',' . $row1['id'] . ')"><i class="fa fa-exchange"></i></button>
                <button title="Eliminar" class="btn btn-danger btn-sm"  onclick="eliminar('.$row1['id'].')"><i class="fa fa-trash"></i></button>
            </td>
        </tr>';
    }
    
    $tableHTML .= '</tbody></table>';
    
    if (!empty($tableHTML)) {
        $response['success'] = true;
        $response['message'] = $tableHTML;
    } else {
        $response['success'] = false;
        $response['message'] = 'No se encontraron elementos para este kit';
    }
    
    header('Content-Type: application/json');
    echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit();

}

if(isset($_POST['historialkit'])){
    
    $idkit = $_POST['historialkit'];
    $qry1 = $mysqli->query("SELECT * FROM `z_productos_kits_elementos_logs` WHERE `idkit`= $idkit");
    
    $response = [];
    $tableHTML = '';
    
    // Generar la cabecera de la tabla
    
    $tableHTML .= '<div class="h3 p-3"><span class="modal-title h5">Información</span><button type="button" class="btn btn-warning float-right m-1" onclick="configkit('.$idkit.')"><i class="fa fa-cog"></i> Configuracion</button></div>';
    $tableHTML .= '<table id="historialkit" class="table table-bordered"><caption><strong>Historial del Kit</strong></caption>';
    $tableHTML .= '<thead>
    <tr>
        <th>Usuario</th>
        <th>Evento</th>
        <th>Producto</th>
        <th>Cantidad</th>
        <th>Seriales</th>
        <th>Nota</th>
        <th>Fecha</th>
    </tr>
    </thead>
    <tbody>';
    
    // Recorrer todos los registros obtenidos de la consulta
    while ($row1 = $qry1->fetch_assoc()) {
        // Preparar los seriales si existen
        $seriales = $row1['seriales'];
        if (!empty($seriales)) {
            $seriales = str_replace(['[', ']', '"'], " ", $seriales);
        } else {
            $seriales = 'Este producto no cuenta con seriales';
        }
        
        $infoproducto = sinfo($row1['idproducto'],'z_productos');
        $infousuario = sinfo($row1['idusuario'],'z_usuarios');
        // Agregar una fila a la tabla
        $tableHTML .= '<tr>
            <td>' . $infousuario['nombre'] . '</td>
            <td>' . $row1['evento'] . '</td>
            <td>' . $infoproducto['producto'] . '</td>
            <td>' . $row1['cantidad'] . '</td>
            <td>' . $seriales . '</td>
            <td>' . $row1['nota'] . '</td>
            <td>' . $row1['fecha'] . '</td>
        </tr>';
    }
    
    $tableHTML .= '</tbody></table>';
    
    if (!empty($tableHTML)) {
        $response['success'] = true;
        $response['message'] = $tableHTML;
    } else {
        $response['success'] = false;
        $response['message'] = 'No se encontraron elementos para este kit';
    }
    
    header('Content-Type: application/json');
    echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit();

}

if(isset($_POST['loadproductokit'])){
    $infokit = sinfo($_POST['loadproductokit'],'z_productos_kits');
    $tableHTML ='<option selected disabled></option>';
    $qry1 = $mysqli->query("SELECT * FROM z_inventario WHERE idempresa={$infokit['idempresa']}"); 
    while($row1 = $qry1->fetch_assoc()){ 
        $infoproducto=sinfo($row1['idproducto'],'z_productos'); 
        $tableHTML .= '<option value="'.$row1['id'].'" data-no="'.$row1['cantidad'].'" data-serial="'.$infoproducto['serial'].'">'.$infoproducto['codigo'].'-'.$infoproducto['no_parte'].'-'.$infoproducto['producto'].'</option>';
    } 
    echo $tableHTML;
    exit();
}


if(isset($_POST['loadserialeskit'])){
    $idproducto = $_POST['loadserialeskit'];
    $infoproducto=sinfo($idproducto,'z_productos'); 
    $tableHTML ='<option selected disabled></option>';
    $qry1 = $mysqli->query("SELECT * FROM z_inventario WHERE id=$idproducto"); 
    $row1 = $qry1->fetch_assoc();
    $seriales = $row1['seriales']; 
    $cantidad = $row1['cantidad']; // Cadena con los seriales
    $seriales = str_replace(['[', ']','"'], '', $seriales); // Quitar los corchetes
    $serialesArray = explode(',', $seriales); // Dividir la cadena en un array usando la coma

    
    if (empty($serialesArray) || (count($serialesArray) === 1 && trim($serialesArray[0]) === '')) {
        // El array está vacío o contiene solo un elemento vacío
        $tableHTML .= '<option>No hay seriales</option>';
    } else {
        // El array tiene elementos válidos
        foreach($serialesArray as $serial){ 
            $tableHTML .= '<option value="'.$serial.'" >'.$serial.'</option>';
        } 
    }
    
    
    
    // Construir la respuesta como un array asociativo
    $response = [
        "success" => true,
        "serial" => $infoproducto['serial'],
        "options" => $tableHTML,
        "cantidad" => $cantidad,
    ];
    
    // Devolver la respuesta en formato JSON
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();

}

if(isset($_POST['addkit'])){
    // Obtener los datos del POST
    $idkit = trim($_POST['addkit']);
    $producto = trim($_POST['producto']);
    $cantidadkit = trim($_POST['cantidadkit']);
    $serialeskit = json_encode($_POST['serialeskit']); // Convertir los seriales en JSON
    $nota = $_POST['nota'];
    
    // Validar que los valores no estén vacíos
    if (empty($idkit) || empty($producto) || empty($cantidadkit)) {
        $response['success'] = false;
        $response['message'] = "Los campos 'producto' y 'cantidad' son obligatorios.";
        echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        exit();
    }
    
    // Validación: Comprobar si el producto ya existe en el kit
    $checkProductoQuery = "SELECT COUNT(*) FROM `z_productos_kits_elementos` WHERE `idkit` = '$idkit' AND `idproducto` = '$producto'";
    $checkProductoResult = $mysqli->query($checkProductoQuery);
    $checkProductoCount = $checkProductoResult->fetch_row()[0];

    if ($checkProductoCount > 0) {
        // El producto ya existe en el kit
        $response['success'] = false;
        $response['message'] = "El producto ya está en este kit.";
        echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        exit();
    }

    // Validación: Comprobar si los seriales ya existen en otro kit
    $seriales = json_decode($serialeskit, true); // Decodificar el JSON de seriales
    $serialesExistentes = [];

    foreach ($seriales as $serial) {
        $checkSerialQuery = "SELECT COUNT(*) FROM `z_productos_kits_elementos` WHERE `seriales` LIKE '%$serial%'";
        $checkSerialResult = $mysqli->query($checkSerialQuery);
        $checkSerialCount = $checkSerialResult->fetch_row()[0];

        if ($checkSerialCount > 0) {
            // Si el serial ya existe en otro kit, lo añadimos a los seriales existentes
            $serialesExistentes[] = $serial;
        }
    }

    if (count($serialesExistentes) > 0) {
        // Si hay seriales existentes, mostrar un mensaje con los seriales que ya están en otro kit
        $response['success'] = false;
        $response['message'] = "Los siguientes seriales ya existen en otro kit: " . implode(', ', $serialesExistentes);
        echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        exit();
    }
    
    $infoproducto = sinfo($producto,'z_productos');
    //Validar si la cantidad considfe con el numero de Seriales
    
    if($infoproducto['serial']){
        if(count($_POST['serialeskit'])!=$cantidadkit){
            // El producto ya existe en el kit
            $response['success'] = false;
            $response['message'] = "La cantidad de seriales no coincide con la cantidad indicada.";
            echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
            exit();
        }
    }
    
    // Si las validaciones pasaron, insertar los datos
    $insertQuery = "INSERT INTO `z_productos_kits_elementos`(`idkit`, `idproducto`, `cantidad`, `seriales`, `nota`) VALUES ('$idkit','$producto','$cantidadkit','$serialeskit','$nota')";
    $mysqli->query("INSERT INTO `z_productos_kits_elementos_logs`(`idkit`, `idproducto`, `cantidad`, `seriales`, `nota`, `evento`, `idusuario`) VALUES ('$idkit','$producto','$cantidadkit','$serialeskit','$nota','Agrego','$idusuario')");
    if ($mysqli->query($insertQuery)) {
        $response['success'] = true;
        $response['message'] = "El producto fue agregado exitosamente al kit.";
    } else {
        $response['success'] = false;
        $response['message'] = "Error al insertar el producto en el kit.";
    }

    // Devolver la respuesta JSON
    header('Content-Type: application/json');
    echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit();
}


if (isset($_POST['eliminaritemkit'])) {
    $idelementkit = $_POST['eliminaritemkit'];
        
    $infoelemento = sinfo($idelementkit,'z_productos_kits_elementos');
    
    $idkit = $infoelemento['idkit'];
    $producto = $infoelemento['idproducto'];
    $cantidadkit = $infoelemento['cantidad'];
    $serialeskit = $infoelemento['seriales'];
    $nota = $infoelemento['nota'];

    $insertQuery = "DELETE FROM z_productos_kits_elementos WHERE `z_productos_kits_elementos`.`id` = $idelementkit";
    $mysqli->query("INSERT INTO `z_productos_kits_elementos_logs`(`idkit`, `idproducto`, `cantidad`, `seriales`, `nota`, `evento`, `idusuario`) VALUES ('$idkit','$producto','$cantidadkit','$serialeskit','$nota','Eliminado','$idusuario')");
    if ($mysqli->query($insertQuery)) {
        $response['success'] = true;
        $response['title'] = "Eliminado";
        $response['message'] = "El elemento fue eliminado exitosamente.";
        $response['type'] = "success";
        $response['reloadconfig'] = $idkit;
    } else {
        $response['success'] = false;
        $response['title'] = "Atención";
        $response['message'] = "Error al eliminar el elemento en el kit.";
        $response['type'] = "error";
    }
        
    // Devolver la respuesta JSON
    header('Content-Type: application/json');
    echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit();
}

if (isset($_POST['trasladarelementkit'])) {
    $idkit = $_POST['idkit'];
    $infokit = sinfo($idkit,'z_productos_kits');
    
    $idempresa = $infokit['idempresa'];
    
    $idelementkit = $_POST['trasladarelementkit'];
        
    $sqlkits = $mysqli->query("SELECT * FROM `z_productos_kits` WHERE `id` != '$idkit' AND `idempresa` = '$idempresa'");
    
    if ($sqlkits->num_rows > 0) {
        // Si hay resultados
        $response['message'] .= "<div class='text-center'><h3>Seleccione un Kit</h3><p>Por favor, seleccione el kit al cual desea trasladar el elemento.</p><ul>";
        $response['success'] = true;
        while($rowkit = $sqlkits->fetch_assoc()) {
            $infoelemento = sinfo($idelementkit, 'z_productos_kits_elementos');
            $response['message'] .= "<li class='btn btn-block btn-link' onclick='trasladarElemento(" . $rowkit['id'] . "," . $idelementkit . ")'>" . $rowkit['kit'] . "</li>";
        }
        $response['message'] .= "</ul></div>";
    } else {
        $response['success'] = false;
        $response['message'] = "<h3>No se encontraron kits disponibles.<h3>";
    }   
    
    // Devolver la respuesta JSON
    header('Content-Type: application/json');
    echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit();
}

if (isset($_POST['trasladarElemento'])) {
    $idelemento = $_POST['idelement'];
    $idkit = $_POST['trasladarElemento'];
    $infoelemento = sinfo($idelemento,'z_productos_kits_elementos');
    
     
    $idkito = $infoelemento['idkit'];
    $producto = $infoelemento['idproducto'];
    $cantidadkit = $infoelemento['cantidad'];
    $serialeskit = $infoelemento['seriales'];
    $nota = $infoelemento['nota'];

    $insertQuery = "UPDATE `z_productos_kits_elementos` SET `idkit` = '$idkit' WHERE `z_productos_kits_elementos`.`id` = $idelemento;";
    $mysqli->query("INSERT INTO `z_productos_kits_elementos_logs`(`idkit`, `idproducto`, `cantidad`, `seriales`, `nota`, `evento`, `idusuario`) VALUES ('$idkit','$producto','$cantidadkit','$serialeskit','$nota','traslado de INGRESO DE $idkit','$idusuario')");
    $mysqli->query("INSERT INTO `z_productos_kits_elementos_logs`(`idkit`, `idproducto`, `cantidad`, `seriales`, `nota`, `evento`, `idusuario`) VALUES ('$idkito','$producto','$cantidadkit','$serialeskit','$nota','traslado de SALIDA A $idkito','$idusuario')");
    if ($mysqli->query($insertQuery)) {
        $response['success'] = true;
        $response['title'] = "Eliminado";
        $response['message'] = "El elemento fue eliminado exitosamente.";
        $response['type'] = "success";
        $response['reloadconfig'] = $idkito;
    } else {
        $response['success'] = false;
        $response['title'] = "Atención";
        $response['message'] = "Error al eliminar el elemento en el kit.";
        $response['type'] = "error";
    }
    
    // Devolver la respuesta JSON
    header('Content-Type: application/json');
    echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit();
}


