<?php
$r= '../';
$titlepage='CONFIGURACION BODEGA';
require_once($r."inc/config.php");
validSession($r);
$mysqli = connectDB($r);
$spe = $_SESSION['perfil'];
$idusuario = $_SESSION['userid'];
roleaccess(440);
include $r."inc/head.php"; ?>

<body class="fixed-nav sticky-footer sidenav-toggled bg-dark" id="page-top">
    <?php include $r."inc/nav.php"; ?>
 
    <div class="content-wrapper">
        <div class="container-fluid row ">
          <!-- Example DataTables Card-->
          <div class="card col-4 pl-0 pr-0">
            <div class="card-header">
              <i class="fa fa-table"></i> ZONAS
              <? if(viewroleaccess(441)){ ?><a class="btn text-primary float-right p-0 ml-3" onclick="NewUser('Zona')" title="Nueva Zona"><i class="fa fa-plus-circle fa-2x"></i></a><? } ?>
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <table class="table table-bordered table-striped" id="dataTable1" data-ajax="server_side/zonas.php" width="100%" cellspacing="0">
                  <thead>
                    <tr>
                      <th>Zonas</th>
                      <th style="width:40px"></th>
                    </tr>
                  </thead>
                </table>
              </div>
            </div>
          </div>
          
          <div class="card col-4 pl-0 pr-0">
            <div class="card-header">
              <i class="fa fa-table"></i> GONDOLAS
              <? if(viewroleaccess(441)){ ?><a class="btn text-primary float-right p-0 ml-3" onclick="NewUser('Gondola')" title="Nueva Gondola"><i class="fa fa-plus-circle fa-2x"></i></a><? } ?>
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <table class="table table-bordered table-striped" id="dataTable2" data-ajax="server_side/gondolas.php"  width="100%" cellspacing="0">
                  <thead>
                    <tr>
                      <th>Gondolas</th>
                      <th style="width:40px"></th>
                    </tr>
                  </thead>
                </table>
              </div>
            </div>
          </div>
          
          <div class="card col-4 pl-0 pr-0">
            <div class="card-header">
              <i class="fa fa-table"></i> ANAQUELES
              <? if(viewroleaccess(441)){ ?><a class="btn text-primary float-right p-0 ml-3" onclick="NewUser('Anaquel')" title="Nuevo Anaquel"><i class="fa fa-plus-circle fa-2x"></i></a><? } ?>
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <table class="table table-bordered table-striped" data-ajax="server_side/anaqueles.php"  id="dataTable3" width="100%" cellspacing="0">
                  <thead>
                    <tr>
                      <th>Anaquel</th>
                      <th style="width:40px"></th>
                    </tr>
                  </thead>
                </table>
              </div>
            </div>
          </div>
        </div>
    </div>
      
  
    <!-- Modal Nueva Zona-->
    <div class="modal fade" id="ModalZona" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="ModalUserTitle">ZONA</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <form id="newformulario1" class="FormZona newformulario"  action="acciones.php" method="POST" data-modal="ModalZona" data-table="dataTable1">
            <div class="modal-body">
                <input type="hidden" name="ActionZona">
                <div class="form-group">
                    <label>Zona</label>
                    <input type="text" name="zona" class="form-control" placeholder="Nombre de la Zona" required>
                </div>
                <div class="form-group">
                    <label>Empresa</label>
                    <select name="empresa" class="form-control" required>
                        <option value="" disabled selected>Empresa...</option>
                        <?php $qry1 = $mysqli->query("SELECT * FROM z_usuarios_empresas WHERE visible=1");
                        while($row1 = $qry1->fetch_assoc()){ ?>
                            <option value="<?= $row1['id']; ?>"><?= $row1['empresa']; ?></option>
                        <? } ?>
                    </select>
                </div>
            </div>
          </form>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRAR</button>
            <button type="submit" form="newformulario1" class="btn btn-primary">GUARDAR</button>
          </div>
        </div>
      </div>
    </div>
    
    <!-- Modal Nueva Zona-->
    <div class="modal fade" id="ModalGondola" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="ModalUserTitle">GONDOLA</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <form id="newformulario2" class="FormGondola newformulario" action="acciones.php" method="POST" data-modal="ModalGondola" data-table="dataTable2">
              <input type="hidden" name="ActionGondola">
              <div class="form-group">
                <label>Gondola</label>
                <input type="text" name="gondola" class="form-control" placeholder="Nombre de la gondola" required>
              </div>
              <div class="form-group">
                <label>Zona</label>
              <select name="zona" class="form-control" required>
                  <option selected disabled>Zonas...</option>
                  <?php $qry1 = $mysqli->query("SELECT * FROM z_inventario_zonas");
                        while($row1 = $qry1->fetch_assoc()){ ?>
                  <option value="<?= $row1['id']; ?>"><?= $row1['zona']; ?></option>
                  <? } ?>
              </select>
              </div>
            </form>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRAR</button>
            <button type="submit" form="newformulario2" class="btn btn-primary">GUARDAR</button>
          </div>
        </div>
      </div>
    </div>
    
    <!-- Modal Nueva Zona-->
    <div class="modal fade" id="ModalAnaquel" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="ModalUserTitle">ANAQUEL</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <form id="newformulario3" class="FormAnaquel newformulario" action="acciones.php" method="POST" data-modal="ModalAnaquel" data-table="dataTable3">
              <input type="hidden" name="ActionAnaquel">
              <div class="form-group">
                <label>anaquel</label>
                <input type="text" name="anaquel" class="form-control" placeholder="Nombre de anaquel..." required>
              </div>
              <div class="form-group">
                <label>Gondola</label>
              <select name="idgondola" class="form-control" required>
                  <option selected disabled>Gondolas...</option>
                  <?php $qry1 = $mysqli->query("SELECT * FROM z_inventario_gondolas");
                        while($row1 = $qry1->fetch_assoc()){ ?>
                  <option value="<?= $row1['id']; ?>"><?= $row1['gondola']; ?></option>
                  <? } ?>
              </select>
              </div>
            </form>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRAR</button>
            <button type="submit" form="newformulario3" class="btn btn-primary">GUARDAR</button>
          </div>
        </div>
      </div>
    </div>
  <?php include $r."inc/foot.php"; ?>
  <script>
    $(document).ready(function(){
        $(".dataTable").each(function(){
            $(this).DataTable();
        });
        $('.newformulario').on('submit', function(e) {
            var form = $(this);
            var idTabla= form.attr('data-table'); // O el método que estés utilizando en tu formulario
            var idModal= form.attr('data-modal');
            // Evita el comportamiento predeterminado de envío del formulario
            e.preventDefault();
            
            // Obtén los datos del formulario
            var formData = $(this).serialize();
            
            // Realiza la solicitud Ajax
            $.ajax({
              type: form.attr('method'), // O el método que estés utilizando en tu formulario
              url: form.attr('action'), // La URL a la que quieres enviar los datos
              data: formData, // Los datos del formulario serializados
              dataType:'json',
              success: function(response) {
                // Maneja la respuesta del servidor si es necesario
                if (response.success) {
                    console.log("#" + idTabla);
                    $("#" + idTabla).DataTable().ajax.reload();
                    $('#' + idModal).modal('hide');
                    form[0].reset();
                    swal(response.message);
                } else {
                    // Mostrar un mensaje de error en algún lugar del formulario
                    swal(response.message);
                }
              },
              error: function(xhr, status, error) {
                // Maneja cualquier error que pueda ocurrir durante la solicitud
                console.error('Error en la solicitud:', error);
              }
            });
        });
    });

    
    configurarDataTable('dataTable1');
    configurarDataTable('dataTable2');
    configurarDataTable('dataTable3');
    
    function configurarDataTable(idTabla) {
        $('#' + idTabla).DataTable({
            "processing": true,
            "serverSide": true,
            "ajax": $('#' + idTabla).data('ajax'),
            // Otras configuraciones...
        });
    }

    function NewUser(modal){
        $('.Form'+ modal )[0].reset();
        $('input[name=Action'+ modal +']').val(0);
        $('#Modal'+modal).modal('show');
    }
    
    function editarzona(id){
        $.post( "acciones.php", { infozona: id })
          .done(function( response ) {
            if (response.success) {
                $('#ModalZona').modal('show');
                $('input[name=ActionZona]').val(response.data.id);
                $('input[name=zona]').val(response.data.zona);
                $('select[name=empresa]').val(response.data.empresa);
            } else {
                // Mostrar un mensaje de error en algún lugar del formulario
                $("#error-message").html(response.message);
            }
        });
    }
    
    function editargondola(id){
        $.post( "acciones.php", { infogondola: id })
          .done(function( response ) {
            if (response.success) {
                $('#ModalGondola').modal('show');
                $('input[name=ActionGondola]').val(response.data.id);
                $('input[name=gondola]').val(response.data.gondola);
                $('select[name=zona]').val(response.data.idzona);
            } else {
                // Mostrar un mensaje de error en algún lugar del formulario
                $("#error-message").html(response.message);
            }
        });
    }
    
    function editaranaquel(id){
        $.post( "acciones.php", { infoanaquel: id })
          .done(function( response ) {
            if (response.success) {
                $('#ModalAnaquel').modal('show');
                $('input[name=ActionAnaquel]').val(response.data.id);
                $('input[name=anaquel]').val(response.data.anaquel);
                $('select[name=idgondola]').val(response.data.idgondola);
            } else {
                // Mostrar un mensaje de error en algún lugar del formulario
                $("#error-message").html(response.message);
            }
        });
    }
    
    function eliminarzona(id){
         swal({
            title: '¿Deseas eliminar la Zona?',
            text: 'Estas apunto de eliminar la zona. Esta acción no se puede deshacer. estas seguro?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar',
            closeOnConfirm: false,
            closeOnCancel: true
        }, function(isConfirm) {
            if (isConfirm) {
                $.post( "acciones.php", { eliminarzona: id })
              .done(function( response ) {
                if (response.success) {
                    
                    $("#dataTable1").DataTable().ajax.reload();
                    swal(response.message);
                } else {
                    // Mostrar un mensaje de error en algún lugar del formulario
                    $("#error-message").html(response.message);
                }
            });
            }
        });
        
    }
    
    function eliminargondola(id){
         swal({
            title: '¿Deseas eliminar la Gondola?',
            text: 'Estas apunto de eliminar la Gondola. Esta acción no se puede deshacer. estas seguro?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar',
            closeOnConfirm: false,
            closeOnCancel: true
        }, function(isConfirm) {
            if (isConfirm) {
                $.post( "acciones.php", { eliminargondola: id })
              .done(function( response ) {
                if (response.success) {
                    
                    $("#dataTable2").DataTable().ajax.reload();
                    swal(response.message);
                } else {
                    // Mostrar un mensaje de error en algún lugar del formulario
                    $("#error-message").html(response.message);
                }
            });
            }
        });
        
    }
    
    function eliminaranaquel(id){
         swal({
            title: '¿Deseas eliminar la Anaquel?',
            text: 'Estas apunto de eliminar la Anaquel. Esta acción no se puede deshacer. estas seguro?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar',
            closeOnConfirm: false,
            closeOnCancel: true
        }, function(isConfirm) {
            if (isConfirm) {
                $.post( "acciones.php", { eliminaranaquel: id })
              .done(function( response ) {
                if (response.success) {
                    
                    $("#dataTable3").DataTable().ajax.reload();
                    swal(response.message);
                } else {
                    // Mostrar un mensaje de error en algún lugar del formulario
                    $("#error-message").html(response.message);
                }
            });
            }
        });
        
    }
    
  </script>
</body>
</html>   