<?php
$r= '../';
$titlepage='KITS';
require_once($r."inc/config.php");
validSession($r);
$mysqli = connectDB($r);
$spe = $_SESSION['perfil'];
$idusuario = $_SESSION['userid'];
roleaccess(430);
include $r."inc/head.php"; ?>

<body class="fixed-nav sticky-footer sidenav-toggled bg-dark" id="page-top">
    <?php include $r."inc/nav.php"; ?>
 
    <div class="content-wrapper">
        <div class="container-fluid">
          <!-- Example DataTables Card-->
          <div class="card mb-3">
            <div class="h3 card-header">
              <i class="fa fa-table"></i> <?= $titlepage; ?>
              <button class="btn btn-primary float-right ml-2" data-toggle="modal" data-target="#CrearKit"><i class="fa fa-plus"></i> CREAR KIT</button>
              <select id="cliente" class="form-control float-right" style="    width: fit-content;">
                  <?php
                  $qry1 = $mysqli->query("SELECT * FROM z_usuarios_empresas WHERE id!=1");
        while($row1 = $qry1->fetch_assoc()){ ?>
                  <option value="<?= $row1['id']; ?>"><?= $row1['empresa']; ?></option>
                  <? } ?>
                  <option value="todos" selected>Todos</option>
              </select>
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <div class="container-fluid">
                    Ver Columna <a class="btn toggle-vis" data-column="5">Seriales</a>
                </div>
                <table class="table table-bordered table-striped" id="dataTable" width="100%" cellspacing="0">
                  <thead>
                    <tr>
                      <th>ID</th>
                      <th>Nombre KIT</th>
                      <th>Empresa</th>
                      <th>Fecha Creacion</th>
                      <th><i class="fa fa-cog"></i></th>
                    </tr>
                  </thead>
                  <tfoot>
                    <tr>
                      <th>ID</th>
                      <th>Nombre KIT</th>
                      <th>Empresa</th>
                      <th>Fecha Creacion</th>
                      <th><i class="fa fa-cog"></i></th>
                    </tr>
                  </tfoot>
                  <tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
    </div>
      
  
    
    
    <!-- The Modal Info KIt-->
    <div class="modal" id="CrearKit">
      <div class="modal-dialog modal-lm">
        <div class="modal-content">
          
          <!-- Modal body -->
          <div class="p-3">
              <h3>Registro de Kit</h3>
                <form id="newkit" class="jquery" action="acciones-kit.php" method="POST">
                  <div class="form-group">
                    <label for="exampleInputEmail1">Nombre Unico</label>
                    <input type="text" class="form-control" name="newkit" aria-describedby="kitHelp" placeholder="Ingrese un nombre único para el kit" required>
                    <small id="kitHelp" class="form-text text-muted">Asegúrese de ingresar un nombre único para identificar el kit de manera exclusiva.</small>
                  </div>
                  <div class="form-group">
                    <label for="exampleInputPassword1">Empresa</label>
                    <select name="idempresa" class="form-control" required>
                      <option value="todos" selected disabled>Seleccione una empresa</option>
                      <?php $qry1 = $mysqli->query("SELECT * FROM z_usuarios_empresas WHERE id!=1");
                        while($row1 = $qry1->fetch_assoc()){ ?>
                      <option value="<?= $row1['id']; ?>"><?= $row1['empresa']; ?></option>
                      <? } ?>
                  </select>
                  </div>
                </form>
          </div>
          
          <!-- Modal footer -->
          <div class="modal-footer">
            <button type="button" class="btn btn-danger float-left" data-dismiss="modal">CERRAR</button>
            <button form="newkit" type="submit" class="btn btn-primary float-right" >CREAR</button>
          </div>
        </div>
      </div>
    </div>
    
    <!-- The Modal Info Kit-->
    <div class="modal" id="AddElemtKit">
      <div class="modal-dialog modal-lm">
        <div class="modal-content">
          <!-- Modal body -->
          <div class="modal-body">
              <h3>Agregar elemento</h3>
            <form id="kitForm" class="jquery" method="POST" action="acciones-kit.php">
              <input type="hidden" name="addkit">
              <div class="mb-3">
                <label for="productokit" class="form-label">Seleccione una producto</label>
                <select class="form-select chosen-select" id="productokit" name="producto" data-placeholder="Seleccione...">
                  <option selected disabled></option>
                </select>
              </div>
              <div class="mb-3">
                <label for="cantidadkit" class="form-label">Ingrese un cantidad</label>
                <input type="number" class="form-control" id="cantidadkit" name="cantidadkit" placeholder="Ejemplo: 10">
              </div>
              <div id="divserialeskit" class="mb-3">
                <label for="serialeskit" class="form-label">Seleccione Seriales</label>
                <select data-placeholder="Seleccione Serial..." id="serialeskit" multiple name="serialeskit[]" class="form-select chosen-select">
                  <option></option>
                </select>
              </div>
              <div class="mb-3">
                <label for="serialeskit" class="form-label">Nota Adicional</label>
                <textarea name="nota" class="form-control"></textarea>
              </div>
              <button type="submit" class="btn btn-primary float-right">Agregar</button>
            </form>
          </div>
        </div>
      </div>
    </div>
    
    <!-- The Modal agregar Elemento-->
    <div class="modal" id="ModalInfo">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          
          <!-- Modal body -->
          <div class="modal-body">
            CARGANDO ...
          </div>
          
          <!-- Modal footer -->
          <div class="modal-footer">
            <button type="button" class="btn btn-danger" data-dismiss="modal">CERRAR</button>
          </div>
        </div>
      </div>
    </div>

    
  <?php include $r."inc/foot.php"; ?>
  <script>
     var table =  $('#dataTable, #configkit').DataTable({
      "processing": true,
      "serverSide": true,
      "ajax": 'server_side/kits.php',
      "paging": true,
      "order": [[1, 'asc']],
       "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Todos"]],
      "ordering": true,
      "searching": true,
      "dom": 'lfBtipr', // Agrega B para los botones
      "buttons": [
            'copy', 'csv', 'excel', 'pdf', 'print'
            // Puedes agregar más botones según tus necesidades
        ]
      // Otras configuraciones...
    });
    
    
    function configkit(id){
        $('.modal').modal('hide');
        $.post( "acciones-kit.php", { configkit: id })
          .done(function( response ) {
            if (response.success) {
                $('#ModalInfo').modal('show');
                $('#ModalInfo .modal-body').html(response.message);
                 $('#configkit').DataTable({destroy: true,dom: 'lfBtipr',buttons: ['copy', 'csv', 'excel', 'pdf', 'print']});
            } else {
                // Mostrar un mensaje de error en algún lugar del formulario
                swal(response.message);
            }
        });
    }
    
    function historialkit(id){
        $('.modal').modal('hide');
        $.post( "acciones-kit.php", { historialkit: id })
          .done(function( response ) {
            if (response.success) {
                $('#ModalInfo').modal('show');
                $('#ModalInfo .modal-body').html(response.message);
                 $('#historialkit').DataTable({destroy: true,dom: 'lfBtipr',buttons: ['copy', 'csv', 'excel', 'pdf', 'print']});
            } else {
                // Mostrar un mensaje de error en algún lugar del formulario
                swal(response.message);
            }
        });
    }
    
    function AddElementKit(id) {
        // Ocultar todas las modales actuales
        $('.modal').modal('hide');
    
        // Realizar la solicitud POST
        $.post("acciones-kit.php", { loadproductokit: id }).done(function(data) {
            $('input[name=addkit]').val(id);
            // Reemplazar el contenido del contenedor con la respuesta del servidor
            $('#productokit').html(data).trigger('chosen:updated');
            // Mostrar la modal específica
            $('#AddElemtKit').modal('show');
        }).fail(function() {
            swal('Error al cargar los datos del producto.');
        });
    }
    
    
    function trasladar(idkit,idelementkit) {
        // Ocultar todas las modales actuales
        $('.modal').modal('hide');
    
        swal({
            title: "¿Estás seguro?",
            text: "¿Deseas trasladar este elemento del kit?",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Sí, trasladar",
            cancelButtonText: "Cancelar",
            closeOnConfirm: false
        },
        function(isConfirm) {
            if (isConfirm) {
                swal.close();
                // Realizar la acción por AJAX
                $.ajax({
                    url: "acciones-kit.php", // Archivo backend
                    type: "POST",
                    dataType: "json", // Esperar respuesta en formato JSON
                    data: { idkit: idkit, trasladarelementkit: idelementkit },
                    success: function(response) {
                        $('#ModalInfo').modal('show');
                        $('#ModalInfo .modal-body').html(response.message);
                    },
                    error: function(xhr, status, error) {
                        // Manejar error en la solicitud
                        swal({
                            title: "Error",
                            text: "Hubo un problema al eliminar el elemento. Intenta nuevamente.",
                            type: "error"
                        });
                    }
                });
            }
        });
    }
    
    function trasladarElemento(idkit, idelement) {
        $.ajax({
            url: "acciones-kit.php", // Archivo backend
            type: "POST",
            dataType: "json", // Esperar respuesta en formato JSON
            data: { trasladarElemento: idkit, idelement: idelement }, // Usar nombres claros de las variables
            success: function(response) {
                swal({
                    title: response.title,
                    text: response.message,  // Asegúrate de que el backend devuelve 'message'
                    icon: response.type      // 'type' se usa para el ícono, usa 'icon' en vez de 'type'
                });
                if (response.reloadconfig) {
                    configkit(response.reloadconfig);
                }
            },
            error: function(xhr, status, error) {
                // Manejar error en la solicitud
                swal({
                    title: "Error",
                    text: "Hubo un problema al trasladar el elemento. Intenta nuevamente.",
                    icon: "error" // 'icon' en lugar de 'type'
                });
            }
        });
    }

    
    function eliminar(idelementkit) {
        // Mostrar confirmación con SweetAlert
        swal({
            title: "¿Estás seguro?",
            text: "¿Deseas eliminar este elemento del kit?",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Sí, eliminar",
            cancelButtonText: "Cancelar",
            closeOnConfirm: false
        },
        function(isConfirm) {
            if (isConfirm) {
                // Realizar la acción por AJAX
                $.ajax({
                    url: "acciones-kit.php", // Archivo backend
                    type: "POST",
                    dataType: "json", // Esperar respuesta en formato JSON
                    data: { eliminaritemkit: idelementkit },
                    success: function(response) {
                        swal({
                            title: response.title,
                            text: response.message,
                            type: response.type
                        });
                        if(response.reloadconfig){
                            configkit(response.reloadconfig);
                        }
                    },
                    error: function(xhr, status, error) {
                        // Manejar error en la solicitud
                        swal({
                            title: "Error",
                            text: "Hubo un problema al eliminar el elemento. Intenta nuevamente.",
                            type: "error"
                        });
                    }
                });
            }
        });
    }

    $(document).ready(function(){
        //load chosen page
         $('.chosen-select').chosen();
        // Recargar la tabla al cambiar el valor del select de Empresas
        $('#cliente').change(function(){
             var selectedPerfil = $(this).val();
        
            // Agrega la condición deseada según el valor seleccionado
            var ajaxUrl = selectedPerfil !== 'Todos' ? 'server_side/kits.php?cliente=' + selectedPerfil : 'server_side/kits.php';
        
            // Recarga la tabla con la nueva URL
            $('#dataTable').DataTable().ajax.url(ajaxUrl).load();
        });
        
        $('#productokit').on("change", function() {
            let id = $(this).val();
        
            $.ajax({
                url: "acciones-kit.php",
                type: "POST",
                data: { loadserialeskit: id },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        if (response.serial == 1) {
                            // Actualizar opciones del select
                            $('#serialeskit').html(response.options).trigger('chosen:updated');
                            $('#divserialeskit').removeClass('d-none');
                        }else{
                            // Actualizar opciones del select
                            $('#serialeskit').html('');
                            $('#divserialeskit').addClass('d-none');
                        }
        
                        // Actualizar atributo max del input cantidad
                        $('#cantidadkit').attr("max", response.cantidad);
                    } else {
                        // Mostrar mensaje de error en la respuesta
                        swal(response.message || "Hubo un error al procesar la solicitud.");
                    }
                },
                error: function(xhr, status, error) {
                    // Manejar errores de la solicitud AJAX
                    console.error('Error en la solicitud AJAX:', error);
                    swal("Error al realizar la solicitud. Por favor, inténtalo de nuevo.");
                }
            });
        });

        
        // Manejo se Submit del formulario
        $('form.jquery').submit(function(e) {
            e.preventDefault();
            var action = $(this).attr('action');
            var method = $(this).attr('method');
            var formData = new FormData($(this)[0]); // Crea un objeto FormData con el formulario
            $.ajax({
                url: action,
                type: method,
                data: formData,
                dataType: 'json',
                processData: false,  // No proceses los datos (FormData lo manejará)
                contentType: false,  // No establezcas el tipo de contenido (FormData lo manejará)
                
                success: function(response) {
                    if (response.success) {
                        $('form.jquery').trigger('reset');
                        $('#dataTable').DataTable().ajax.reload();
                        swal(response.message);
                    } else {
                        // Si la solicitud fue exitosa pero se recibe un mensaje de error
                        // Mostrar un mensaje de error en algún lugar del formulario
                        swal(response.message);
                    }
                },
                error: function(xhr, status, error) {
                    // Manejar los errores de la solicitud AJAX
                    console.error('Error en la solicitud AJAX:', error);
                }
            })
        });
        
        
  });
  </script>
</body>
</html>   