<?php
$r= '../';
require_once($r."inc/config.php");
$mysqli = connectDB($r);
session_start();
$idusuario = $_SESSION['userid'];

// RESPUESTA JSON
$response = [
    "success" => false,
    "message" => "Accin no vlida."
];

// --- ELIMINAR BROCHURE ---
if (
    $_SERVER['REQUEST_METHOD'] === 'POST' &&
    isset($_POST['accion']) &&
    $_POST['accion'] === 'eliminar_brochure' &&
    isset($_POST['id'])
) {
    $id = intval($_POST['id']);

    // Eliminar de base de datos
    $stmtDel = $mysqli->prepare("DELETE FROM call_brochures WHERE id = ?");
    $stmtDel->bind_param("i", $id);
    if ($stmtDel->execute()) {
        $response["success"] = true;
        $response["message"] = "Brochure eliminado correctamente.";
        $response["modal"] = true;
        $response["table"] = ["#dataTableLista"];
    } else {
        $response["message"] = "Error al eliminar de la base de datos.";
    }
    $mysqli->close();
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}

// --- SUBIR BROCHURE ---
if (
    $_SERVER['REQUEST_METHOD'] === 'POST' &&
    isset($_POST['nombre_archivo']) &&
    isset($_POST['descripcion_archivo']) &&
    isset($_FILES['brochure'])
) {
    $nombre = trim($_POST['nombre_archivo']);
    $descripcion = trim($_POST['descripcion_archivo']);
    $archivo = $_FILES['brochure'];
    $idusuario = 1; // Asigna el ID del usuario actual si aplica

    $tipoPermitido = 'application/pdf';
    if ($archivo['type'] !== $tipoPermitido) {
        $response['message'] = "Error: solo se permiten archivos PDF.";
    } elseif ($archivo['error'] !== UPLOAD_ERR_OK) {
        $response['message'] = "Error al subir el archivo.";
    } else {
        $directorio = 'uploads/';
        if (!is_dir($directorio)) {
            mkdir($directorio, 0755, true);
        }

        $nombreFinal = uniqid('brochure_') . '.pdf';
        $rutaDestino = $directorio . $nombreFinal;

        if (move_uploaded_file($archivo['tmp_name'], $rutaDestino)) {
            $stmt = $mysqli->prepare("INSERT INTO call_brochures (nombre, descripcion, ruta, idusuario) VALUES (?, ?, ?, ?)");
            if ($stmt) {
                $stmt->bind_param("sssi", $nombre, $descripcion, $nombreFinal, $idusuario);
                if ($stmt->execute()) {
                    $response["success"] = true;
                    $response["message"] = "Archivo subido y datos guardados correctamente.";
                    $response["modal"] = true;
                    $response["table"] = ["#dataTableLista"];
                } else {
                    $response['message'] = "Error al guardar en la base de datos: " . $stmt->error;
                }
                $stmt->close();
            } else {
                $response['message'] = "Error en la preparacin de la consulta: " . $mysqli->error;
            }
        } else {
            $response['message'] = "Error al mover el archivo.";
        }
    }

    $mysqli->close();
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}

// SI LLEGA AQU01, NO CUMPLI07 NINGUNA CONDICI07N
header('Content-Type: application/json');
echo json_encode($response);
exit;
?>

?>
