<?php
$r= '../../';
require_once($r."inc/config.php");

$mysqli = connectDB($r);
session_start();
$spe=$_SESSION['perfil'];
$idusuario=$_SESSION['id'];
$extraCondition = '';

$acciones = viewroleaccess(611);
$asignar = viewroleaccess(611);
$cita = viewroleaccess(612);
$reagendar = viewroleaccess(613);

function htmlclear($row) {
    global $acciones, $cita, $reagendar, $asignar;

    $icons = [];

    // Ícono de acciones generales
    $icons[] = '<i style="cursor:pointer" title="Ver '.$row['nombre'].'" onclick="verbrochure(\''.$row['ruta'].'\')" class="text-primary fa fa-file-pdf-o fa-2x mr-2"></i>';
    $icons[] = '<i style="cursor:pointer" title="Eliminar '.$row['nombre'].'" onclick="delbrochure('.$row['id'].')" class="text-danger fa fa-trash fa-2x mr-2"></i>';
    return implode('', $icons);
}


/*
 * DataTables example server-side processing script.
 *
 * Please note that this script is intentionally extremely simple to show how
 * server-side processing can be implemented, and probably shouldn't be used as
 * the basis for a large complex system. It is suitable for simple use cases as
 * for learning.
 *
 * See https://datatables.net/usage/server-side for full details on the server-
 * side processing requirements of DataTables.
 *
 * @license MIT - https://datatables.net/license_mit
 */
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 
// DB table to use
$table = 'call_brochures';
 
// Table's primary key
$primaryKey = 'id';
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case simple
// indexes

$columns = array(
    array( 'db' => 't1.id'),
    array( 'db' => 't1.nombre', 'dt' => 0 ),
    array( 'db' => 't1.descripcion', 'dt' => 1 ),
    array(
        'db'        => 't1.ruta',
        'dt'        => 2,
        'formatter' => function( $d, $row ) {
            return htmlclear($row);
        })
    
);

// SQL server connection information
$sql_details = array(
    'user' => $bduser,
    'pass' => $bdpass,
    'db'   => $bdname,
    'host' => $server,
    'charset' => 'utf8' // Depending on your PHP and MySQL config, you may need this
);

 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
 
require( 'ssp.class.php' );
$joinQuery = "FROM `{$table}` AS `t1`";

// Validar si existe 'tbestado' en GET y es diferente de "Todos"
if (isset($_GET['tbestado']) && $_GET['tbestado'] !== 'todos') {
    $tbestado = $_GET['tbestado'];
    $extraCondition = "t1.estado = $tbestado";
}

echo json_encode( SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $extraCondition), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);

