<?php
$r = '../';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../vendor/PHPMailer/src/PHPMailer.php';
require '../vendor/PHPMailer/src/SMTP.php';
require '../vendor/PHPMailer/src/Exception.php';
                
session_start();
require_once($r."inc/config.php");
$mysqli = connectDB($r);
$idusuario = $_SESSION['userid'];


if (isset($_POST['infodatacliente'])) {
    $iddatacliente = $_POST['infodatacliente'];
    
    $qry0 = $mysqli->query("SELECT * FROM `call_data_clientes` WHERE id = $iddatacliente");
    $num0 = $qry0->num_rows;
    
    if ($num0) {
        while ($row0 = $qry0->fetch_assoc()) {
            // Obtener sectores asociados
            $sectores = [];
            $qry1 = $mysqli->query("
                SELECT cs.id_sector
                FROM call_data_clientes_sectores cs
                WHERE cs.id_data = $iddatacliente
            ");
            while ($row1 = $qry1->fetch_assoc()) {
                $sectores[] = $row1['id_sector'];
            }

            // Agregar los sectores al array de cliente
            $row0['sector_economico'] = $sectores;

            // Guardar en la respuesta
            $response['message'] = json_encode($row0);
        }
    } else {
        $response['message'] = "ERROR NO HAY ARCHIVOS SOPORTE";
    }

    $response['success'] = true;
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}


if(isset($_POST['iddatacliente'])){
    $iddatacliente = $_POST['iddatacliente'] ?? null;
    $empresa = $_POST['empresa'] ?? null;
    $correo = $_POST['correo'] ?? null;
    $sectores = $_POST['sectores'] ?? [];
    $direccion = $_POST['direccion'] ?? null;
    $contacto = $_POST['contacto'] ?? null;
    $telefono = $_POST['telefono'] ?? null;
    $estados = isset($_POST['accion']) ? (int) $_POST['accion'] : null;
    
    $response = ['success' => false, 'message' => ''];
    
    if (empty($iddatacliente)) {
        $response['message'] = "ERROR: ID de cliente es obligatorio";
    } else {
        $campos = [];
        $parametros = [];
        $tipos = "";
    
        if (!empty($empresa)) {
            $campos[] = "`empresa` = ?";
            $parametros[] = $empresa;
            $tipos .= "s";
        }
        if (!empty($correo)) {
            $campos[] = "`correo` = ?";
            $parametros[] = $correo;
            $tipos .= "s";
        }
        if (!empty($direccion)) {
            $campos[] = "`direccion` = ?";
            $parametros[] = $direccion;
            $tipos .= "s";
        }
        if (!empty($contacto)) {
            $campos[] = "`contacto` = ?";
            $parametros[] = $contacto;
            $tipos .= "s";
        }
        if (!empty($telefono)) {
            $campos[] = "`telefono` = ?";
            $parametros[] = $telefono;
            $tipos .= "s";
        }
        if ($estados !== null) {
            $campos[] = "`estado` = ?";
            $parametros[] = $estados;
            $tipos .= "i";
        }
    
        if (!empty($campos)) {
            $query = "UPDATE `call_data_clientes` SET " . implode(", ", $campos) . " WHERE `id` = ?";
            $parametros[] = $iddatacliente;
            $tipos .= "i";
    
            $stmt = $mysqli->prepare($query);
            $stmt->bind_param($tipos, ...$parametros);
            
            
            
    
            if ($stmt->execute()) {
                // Eliminar sectores anteriores
                    $stmtDel = $mysqli->prepare("DELETE FROM call_data_clientes_sectores WHERE id_data = $iddatacliente");
                    $stmtDel->bind_param("i", $iddatacliente);
                    $stmtDel->execute();
                    $stmtDel->close();

                    // Insertar nuevos sectores
                    if (!empty($sectores)) {
                        $stmtIns = $mysqli->prepare("INSERT INTO call_data_clientes_sectores (id_data, id_sector) VALUES (?, ?)");
                        foreach ($sectores as $sector_id) {
                            $stmtIns->bind_param("ii", $iddatacliente, $sector_id);
                            $stmtIns->execute();
                        }
                        $stmtIns->close();
                    }
                $adjuntos = array(__DIR__ . "/../brochures/uploads/0.pdf");

                // Adjuntar los demás seleccionados (si existen)
                if (isset($_POST['brochure']) && is_array($_POST['brochure'])) {
                    foreach ($_POST['brochure'] as $valor) {
                        $archivo = __DIR__ . "/../brochures/uploads/{$valor}";
                        array_push($adjuntos, $archivo);
                    }
                }
                
                $infoestado =  sinfo($estados,'call_data_estados');
                
                if($infoestado['email']){
                
                    $resultado = enviarCorreoGuiatransportes($empresa, $correo, $adjuntos);
                }
                $response['success'] = true;
                $response['message'] = "Datos actualizados correctamente";
                $response["table"] =  array("#dataTableLista");
                $response["modal"] = true;
                if($estados === 4){
                    $contacto_cita = $_POST['contacto_cita'];
                    $telefono_cita = $_POST['telefono_cita'];
                    $correo_cita = $_POST['correo_cita'];
                    $direccion_cita = $_POST['direccion_cita'];
                    $tipo_cita = $_POST['tipo_cita'];
                    $fecha_cita = $_POST['fecha_cita'];
                    $hora_cita = $_POST['hora_cita'];
                    $servicio_interes = $_POST['servicio_interes'];
                    $nota_cita = $_POST['nota_cita'];
                    $mysqli->query("INSERT INTO `call_data_visitas`(`id_data`, `contacto`, `telefono`, `correo`, `direccion`, `tipo`, `fecha`, `hora`, `servicio`, `id_usuario`) VALUES ($iddatacliente,'$contacto_cita','$telefono_cita','$correo_cita','$direccion_cita',$tipo_cita,'$fecha_cita','$hora_cita',$servicio_interes,$idusuario)");
                    $response["table"] =  array("#dataTableLista", "#dataTableCitas");
                    $response["modal"] = true;
                }elseif($estados === 5){
                    $contacto_llamada = $_POST['contacto_llamada'];
                    $telefono_llamada = $_POST['telefono_llamada'];
                    $correo_llamada = $_POST['correo_llamada'];
                    $fecha_llamada = $_POST['fecha_llamada'];
                    $hora_llamada = $_POST['hora_llamada'];
                    $mysqli->query("INSERT INTO `call_data_llamadas`(`id_data`, `contacto`, `telefono`, `correo`, `fecha_programada`, `hora_programada`, `id_usuario`) VALUES ($iddatacliente,'$contacto_llamada','$telefono_llamada','$correo_llamada','$fecha_llamada','$hora_llamada',$idusuario)");
                    $response["table"] =  array("#dataTableLista", "#dataTableLlamadas");
                    $response["modal"] = true;
                }
                
            } else {
                $response['message'] = "Error al actualizar los datos";
            }
    
            $stmt->close();
        } else {
            $response['message'] = "ERROR: No se enviaron datos para actualizar";
        }
    }
    
    
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}

if(isset($_POST['addcita'])) {
    $formulario = <<<HTML
        <h5>Agendar Cita</h5>
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label for="tipo-cita">Contacto</label>
                    <input type="text" class="form-control" name="contacto_cita" placeholder="Persona de Contacto..." form="form-cliente" required>
                </div>
            </div>

            <div class="col-md-4">
                <div class="form-group">
                    <label for="fecha-cita">Telefono Contacto</label>
                    <input type="number" class="form-control" name="telefono_cita" form="form-cliente" required>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="fecha-cita">Correo Contacto</label>
                    <input type="mail" class="form-control" name="correo_cita" form="form-cliente" required>
                </div>
            </div>

            <div class="col-md-4">
                <div class="form-group">
                    <label for="hora-cita">Direccion</label>
                    <!-- Tu input ya existente -->
                    <input type="text" class="form-control" id="direccion_cita" name="direccion_cita" placeholder="Escribe la dirección..." autocomplete="off">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="tipo-cita">Tipo de Cita</label>
                    <select class="form-control" name="tipo_cita" id="tipo-cita" form="form-cliente" required>
                        <option value="" selected disabled>Seleccione...</option>
                        <option value="1">Virtual</option>
                        <option value="2">Presencial</option>
                    </select>
                </div>
            </div>


            <div class="col-md-4">
                <div class="form-group">
                    <label for="servicio-interes">Servicio de Interés</label>
                    <select class="form-control" name="servicio_interes" id="servicio-interes" form="form-cliente" required>
                        <option value="" selected disabled>Seleccione...</option>
                        <option value="1">Transporte</option>
                        <option value="2">Almacenamiento</option>
                        <option value="3">Ambos</option>
                    </select>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="form-group">
                    <label for="fecha-cita">Fecha</label>
                    <input type="date" class="form-control" id="fecha-cita" name="fecha_cita" form="form-cliente" required>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="form-group">
                    <label for="hora-cita">Hora</label>
                    <input type="time" class="form-control" id="hora-cita" name="hora_cita" form="form-cliente" required>
                </div>
            </div>

            <div class="col-md-12">
                <div class="form-group">
                    <label for="nota-cita">Nota Adicional</label>
                    <textarea class="form-control" id="nota-cita" name="nota_cita" form="form-cliente" rows="2"></textarea>
                </div>
            </div>
        </div>

HTML;

    echo $formulario;
}

if(isset($_POST['addcall'])) {
    $formulario_llamada = '
        <h5>Agendar Llamada</h5>
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label for="tipo-cita">Contacto</label>
                    <input type="text" class="form-control" name="contacto_llamada" placeholder="Persona de Contacto..." form="form-cliente" required>
                </div>
            </div>

            <div class="col-md-4">
                <div class="form-group">
                    <label for="fecha-cita">Telefono Contacto</label>
                    <input type="number" class="form-control" name="telefono_llamada" form="form-cliente" required>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="fecha-cita">Correo Contacto</label>
                    <input type="mail" class="form-control" name="correo_llamada" form="form-cliente" required>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="fecha-llamada">Fecha</label>
                    <input type="date" class="form-control" id="fecha-llamada" name="fecha_llamada" form="form-cliente" required>
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group">
                    <label for="hora-llamada">Hora</label>
                    <input type="time" class="form-control" id="hora-llamada" name="hora_llamada" form="form-cliente" required>
                </div>
            </div>
        </div>';

    echo $formulario_llamada;
}

if(isset($_POST['idendevent'])) {
    $idendevent = $_POST['idendevent'];
    $tipo = $_POST['tipo'];
    if ($tipo == 'cita') {
        $query = "SELECT id, estado FROM call_data_visitas_estados WHERE finalizar=1";
    } elseif ($tipo == 'llamada') {
        $query = "SELECT id, estado FROM call_data_llamadas_estados WHERE finalizar=1";
    } 
    // Ejecutar consulta
    $result = $mysqli->query($query);
    $select_options = '';
    while ($row = $result->fetch_assoc()) {
        $select_options .= '<option value="' . $row['id'] . '">' . $row['estado'] . '</option>';
    }
    $formulario = '
                <input type="hidden" name="eventend" value="' .$idendevent . '">
                <input type="hidden" name="tipo" value="' . $tipo . '">
                <div class="form-group">
                    <label for="estado">Estado</label>
                    <select class="form-control" id="estado" name="estado" required>
                        <option value="">Seleccione un estado</option>
                        ' . $select_options . '
                    </select>
                </div>
                <div class="form-group">
                    <label for="estado">Observaciones</label>
                    <textarea class="form-control" name="notaadicional" placeholder="Observaciones"></textarea>
                </div>';
    echo $formulario;
}


if (isset($_POST['iddatabrochure'])) {
    $infocliente = sinfo($_POST['iddatabrochure'], 'call_data_clientes');
    $empresa = $infocliente['empresa'];
    $correo = $infocliente['correo'];

    $adjuntos = array();
    if (isset($_POST['brochure']) && is_array($_POST['brochure'])) {
        foreach ($_POST['brochure'] as $brochureId) {
            $infobrochure = sinfo($brochureId, 'call_brochures');
            $archivo = __DIR__ . "/../brochures/uploads/{$infobrochure['ruta']}";
            array_push($adjuntos, $archivo);
        }
    }

    $resultado = enviarCorreoGuiatransportes($empresa, $correo, $adjuntos);
    $response["success"] = true;
    $response["message"] = "Asesor se ha asignado";
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}

                    
if(isset($_POST['eventend'])) {
    $idvent = $_POST['eventend'] ?? null;
    $tipo = $_POST['tipo'] ?? null;
    $estado = $_POST['estado'] ?? null;
    $nota = $_POST['notaadicional'] ?? null;
    
    if (empty($idvent) || empty($tipo) || empty($estado) || empty($nota)) {
        $response["success"] = false;
        $response["message"] = "Todos los campos son obligatorios.";
        header('Content-Type: application/json');
        echo json_encode($response);
        exit();
    }
    if($tipo == 'llamada'){
        $mysqli->query("UPDATE `call_data_llamadas` SET `id_usuario_cierre`=$idusuario,`fecha_cierre`=NOW(),`nota_cierre`='$nota', estado=$estado WHERE `id` = $idvent");
        $response["table"] =  array("#dataTableLlamadas");
        $response["modal"] = true;
    }elseif($tipo == 'cita'){
        $mysqli->query("UPDATE `call_data_visitas` SET `id_usuario_cierre`=$idusuario,`fecha_cierre`=NOW(),`nota_cierre`='$nota', estado=$estado  WHERE `id` = $idvent");
        $response["table"] =  array("#dataTableCitas");
        $response["modal"] = true;
    }
    $response["success"] = true;
    $response["message"] = "Asesor se ha asignado".$idvent;
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}

if(isset($_POST['idevent'])) {
    $idvent = $_POST['idevent'] ?? null;
    $tipo = $_POST['tipoevent'] ?? null;
    $asesor = $_POST['asesor'] ?? null;
    
    if (empty($idvent) || empty($tipo) || empty($asesor)) {
        $response["success"] = false;
        $response["message"] = "Todos los campos son obligatorios.";
        header('Content-Type: application/json');
        echo json_encode($response);
        exit();
    }
    if($tipo == 'llamada'){
        $mysqli->query("UPDATE `call_data_llamadas` SET id_usuario_asignado=$asesor, estado=2 WHERE `id` = $idvent");
        $response["table"] =  array("#dataTableLlamadas");
        $response["modal"] = true;
    }elseif($tipo == 'cita'){
        $mysqli->query("UPDATE `call_data_visitas` SET id_usuario_asignado=$asesor, estado=2  WHERE `id` = $idvent");
        $response["table"] =  array("#dataTableCitas");
        $response["modal"] = true;
    }
    $response["success"] = true;
    $response["message"] = "Asesor se ha asignado".'asdasd'.$idvent;
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}

if(isset($_POST['reagendaridevent'])) {
    $idvent = $_POST['reagendaridevent'] ?? null;
    $tipo = $_POST['reagendartipoevent'] ?? null;
    $fecha = $_POST['fecha_cita'] ?? null;
    $hora = $_POST['hora_cita'] ?? null;
    $nota = $_POST['nota_cita'] ?? null;
    
    if (empty($fecha) || empty($hora) || empty($nota)) {
        $response["success"] = false;
        $response["message"] = "Todos los campos son obligatorios.";
        header('Content-Type: application/json');
        echo json_encode($response);
        exit();
    }
    if($tipo == 'llamada'){
        $mysqli->query("UPDATE `call_data_llamadas` SET `id_usuario_cierre`=$idusuario,`fecha_cierre`=NOW(),`nota_cierre`='$nota',  estado=6 WHERE `id` = $idvent");
        /*$infoevent =  sinfo($idvent,'call_data_llamadas');*/
        //$mysqli->query("INSERT INTO `call_data_visitas`(`id_data`, `contacto`, `telefono`, `direccion`, `tipo`, `fecha`, `hora`, `servicio`, `id_usuario`) VALUES ($iddatacliente,'$contacto_cita','$telefono_cita','$direccion_cita',$tipo_cita,'$fecha_cita','$hora_cita',$servicio_interes,$idusuario)");
        $response["table"] =  array("#dataTableLlamadas");
        $response["modal"] = true;
    }elseif($tipo == 'cita'){
        $mysqli->query("UPDATE `call_data_visitas` SET `id_usuario_cierre`=$idusuario,`fecha_cierre`=NOW(),`nota_cierre`='$nota',  estado=6  WHERE `id` = $idvent");
        /*$infoevent =  sinfo($idvent,'call_data_visitas');
        $iddata = $infoevent['id_data'];
        $contacto = $infoevent['contacto'];
        $telefono = $infoevent['telefono'];
        $telefono = $infoevent['id_usuario_asignado'];*/
        
        //$mysqli->query("INSERT INTO `call_data_llamadas`(`id_data`, `contacto`, `telefono`, `fecha_programada`, `hora_programada`, `id_usuario`) VALUES ($iddatacliente,'$contacto_llamada','$telefono_llamada','$fecha_llamada','$hora_llamada',$idusuario)");
        $response["table"] =  array("#dataTableCitas");
        $response["modal"] = true;
    }
    $response["success"] = true;
    $response["message"] = "Asesor se ha asignado".'asdasd'.$idvent;
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}

if (isset($_POST['procesar_tarea'])) {
    
    $response = ["success" => false, "message" => ""]; // estructura base
    $id = isset($_POST['id']) ? intval($_POST['id']) : 0;
    $tipo = $_POST['tipo'] ?? '';
    $accion = $_POST['procesar_tarea'];

    // Validación de ID
    if ($id <= 0) {
        $response["message"] = "ID de tarea no válido.";
        echo json_encode($response); exit;
    }

    // Validación de tipo y tabla
    if ($tipo === 'llamada') {
        $tabla = 'call_data_llamadas';
        $response["table"] = array("#dataTableLlamadas");
    } elseif ($tipo === 'cita') {
        $tabla = 'call_data_visitas';
        $response["table"] = array("#dataTableCitas");
    } else {
        $response["success"] = false;
        $response["message"] = "Tipo de tarea desconocido.";
        echo json_encode($response); exit;
    }

    // Validar y ejecutar acción
    if ($accion === 'aceptar') {
        $sql = "UPDATE $tabla SET estado = 3 WHERE id = $id";
    } elseif ($accion === 'rechazar') {
        $sql = "UPDATE $tabla SET estado = 9 WHERE id = $id";
    } else {
        
        $response["success"] = false;
        $response["message"] = "Acción no reconocida.";
        echo json_encode($response); exit;
    }

    // Ejecutar y manejar errores SQL
    if ($mysqli->query($sql)) {
        $response["success"] = true;
        $response["modal"] = true;
        $response["message"] = "La tarea ha sido procesada correctamente.";
    } else {
        $response["message"] = "Error al ejecutar la consulta SQL: " . $mysqli->error;
    }

    
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}


if (isset($_POST['info_tarea'])) {
    $id = intval($_POST['info_tarea']);
    $tipo = $_POST['tipo'];

    if ($tipo === 'cita') {
        $tabla = 'call_data_visitas';
    } elseif ($tipo === 'llamada') {
        $tabla = 'call_data_llamadas';
    }

    $data = sinfo($id, $tabla); // Función que retorna el array

    ob_start();
    ?>
    <div class="table-responsive">
        <table class="table table-bordered table-striped mb-0">
            <tbody>
                <tr>
                    <th scope="row">Contacto</th>
                    <td><?= $data['contacto'] ?></td>
                </tr>
                <tr>
                    <th scope="row">Teléfono</th>
                    <td><?= $data['telefono'] ?></td>
                </tr>

                <?php if ($tipo === 'cita'): ?>
                    <tr>
                        <th scope="row">Dirección</th>
                        <td><?= $data['direccion'] ?></td>
                    </tr>
                    <tr>
                        <th scope="row">Tipo</th>
                        <td><?= $data['tipo'] ?></td>
                    </tr>
                    <tr>
                        <th scope="row">Fecha</th>
                        <td><?= $data['fecha'] ?></td>
                    </tr>
                    <tr>
                        <th scope="row">Hora</th>
                        <td><?= $data['hora'] ?></td>
                    </tr>
                    <tr>
                        <th scope="row">Servicio</th>
                        <td><?= $data['servicio'] ?></td>
                    </tr>
                <?php else: ?>
                    <tr>
                        <th scope="row">Fecha programada</th>
                        <td><?= $data['fecha_programada'] ?></td>
                    </tr>
                    <tr>
                        <th scope="row">Hora programada</th>
                        <td><?= $data['hora_programada'] ?></td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="text-center mt-4">
        <a class="btn btn-success mx-2" onclick="responderTarea('<?= $data['id'] ?>', '<?= $tipo ?>', 'aceptar')">Aceptar</a>
        <a class="btn btn-danger mx-2" onclick="responderTarea('<?= $data['id'] ?>', '<?= $tipo ?>', 'rechazar')">Rechazar</a>
    </div>
    <?php

    $response = [
        "success" => true,
        "message" => ob_get_clean()
    ];

    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}

if (isset($_POST['obtenerevento'])) {
    $id = intval($_POST['obtenerevento']);
    $tipo = $_POST['tipo'];
    if ($tipo === 'cita') {
        $tabla = 'call_data_visitas';
        $infoevento = sinfo($id, $tabla); 
        $data = array( 'nombre'=>$infoevento['contacto'], 'telefono'=>$infoevento['telefono'], 'fecha'=>$infoevento['fecha'], 'hora'=>$infoevento['hora'], 'ubicacion'=>$infoevento['direccion'], 'correo'=>$infoevento['correo'], 'modalidad'=>$infoevento['tipo']);
    } elseif ($tipo === 'llamada') {
        $tabla = 'call_data_llamadas';
        $infoevento = sinfo($id, $tabla); 
        $data = array( 'nombre'=>$infoevento['contacto'], 'telefono'=>$infoevento['telefono'], 'fecha'=>$infoevento['fecha_programada'], 'hora'=>$infoevento['hora_programada'], 'ubicacion'=>$infoevento['direccion'], 'correo'=>$infoevento['correo'], 'modalidad'=>$infoevento['tipo']);
    }

    
    if ($data) {
    echo json_encode($data);
    } else {
        echo json_encode(['error' => 'Evento no encontrado']);
    }
}


if(isset($_POST['iddatafidelizar'])){
    $iddata = $_POST['iddatafidelizar'];
    $tipo = isset($_POST['tipo_seleccion']) ? $_POST['tipo_seleccion'] : '';

    if ($tipo === 'semana') {
        $dias = isset($_POST['dias_semana']) ? $_POST['dias_semana'] : [];
        $dias_str = implode(',', $dias);
        
        $mysqli->query("UPDATE call_data_clientes SET tipo = '$tipo', dias = '$dias_str' WHERE id = $iddata");
    
    } elseif ($tipo === 'mes') {
        $dias = isset($_POST['dias_mes']) ? $_POST['dias_mes'] : [];
        $dias_str = implode(',', $dias);
    
        $mysqli->query("UPDATE call_data_clientes SET tipo = '$tipo', dias = '$dias_str' WHERE id = $iddata");
    
    } 
    
    $response["success"] = true;
    $response["message"] = "Asesor se ha asignado";
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();  
}

function detectDelimiter($filename) {
    $delimiters = ["," => 0, ";" => 0];
    $handle = fopen($filename, 'r');
    $line = fgets($handle);
    fclose($handle);
    foreach ($delimiters as $delimiter => &$count) {
        $count = count(str_getcsv($line, $delimiter));
    }
    return array_search(max($delimiters), $delimiters);
}

if(isset($_POST['csv'])) {

    $fileTmpName = $_FILES['archivo']['tmp_name'];
    $fileName = $_FILES['archivo']['name'];
    $fileType = $_FILES['archivo']['type'];
    $asesorId = $_POST['asesor'];
    $accion = $_POST['accion']; // ✅ esta línea era necesaria
    
    // Validación: extensión y tipo MIME
    $ext = pathinfo($fileName, PATHINFO_EXTENSION);
    $allowedMimeTypes = ['text/csv', 'application/vnd.ms-excel', 'text/plain'];

    if (strtolower($ext) !== 'csv' || !in_array($fileType, $allowedMimeTypes)) {
            $response["message"] = "El archivo cargado no es un CSV válido";
            $response["success"] = false;
            header('Content-Type: application/json');
            echo json_encode($response);
            exit();  
    }
    
    $delimiter = detectDelimiter($fileTmpName);

    if (($handle = fopen($fileTmpName, 'r')) !== FALSE) {
        $headers = fgetcsv($handle, 0, $delimiter); // leer cabecera
        
        
        if ($primeraFila === false || count(array_filter($primeraFila)) === 0) {
            $response["success"] = false;
            $response["message"] = "❌ El archivo solo contiene encabezado. Debe tener al menos una fila de datos.";
            header('Content-Type: application/json');
            echo json_encode($response);
            exit;
        }

        $filasValidas = [];
        $errores = [];
        $linea = 1;
        
        // 1. Primera pasada: validar
        while (($data = fgetcsv($handle, 0, $delimiter)) !== FALSE) {
        $linea++;
    
        if ($accion == 1) {
            if (count($data) < 8) {
                $errores[] = "❌ Error en línea $linea: se requieren al menos 8 columnas para importar.";
                continue;
            }
    
            $datosVacios = false;
            for ($i = 0; $i <= 7; $i++) {
                if (!isset($data[$i]) || trim($data[$i]) === '') {
                    $datosVacios = true;
                    break;
                }
            }
    
            if ($datosVacios) {
                $errores[] = "❌ Error en línea $linea: columnas 1 a 8 incompletas.";
            } else {
                $filasValidas[] = $data;
            }
    
        } elseif ($accion == 2) {
            if (!isset($data[0]) || trim($data[0]) === '') {
                $errores[] = "❌ Error en línea $linea: columna 1 (empresa) es obligatoria para actualizar.";
            } else {
                $filasValidas[] = $data;
            }
        }
    }

        
        // 2. Si hay errores, mostrar y no continuar
        if (!empty($errores)) {
            foreach ($errores as $error) {
                  $response["message"] .= $error;
            }
            $response["success"] = false;
            header('Content-Type: application/json');
            echo json_encode($response);
            exit();  
        }
        
        // 3. Si todo está bien, procesar los INSERTs
        foreach ($filasValidas as $data) {
            $empresa   = $data[0];
            $correo    = $data[1];
            $direccion = $data[2];
            $barrio    = $data[3];
            $ciudad    = $data[4];
            $contacto  = $data[5];
            $telefono  = $data[6];
            $sectores  = array_filter(array_slice($data, 7, 4)); // índices 7 a 10
        
            if ($accion == 1) {
                $query = "INSERT INTO call_data_clientes (empresa, correo, direccion, barrio, ciudad, contacto, telefono, id_asesor) 
                          VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
                if ($stmt = $mysqli->prepare($query)) {
                    $stmt->bind_param("sssssssi", $empresa, $correo, $direccion, $barrio, $ciudad, $contacto, $telefono, $asesorId);
                    $stmt->execute();
        
                    $id_data = $stmt->insert_id;
        
                    if (!empty($sectores)) {
                        $querySector = "INSERT INTO call_data_clientes_sectores (id_data, id_sector) VALUES (?, ?)";
                        $stmtSector = $mysqli->prepare($querySector);
                        foreach ($sectores as $id_sector) {
                            $id_sector = intval($id_sector);
                            $stmtSector->bind_param("ii", $id_data, $id_sector);
                            $stmtSector->execute();
                        }
                    }
                }
            } elseif ($accion == 2) {
                $query = "UPDATE call_data_clientes SET id_asesor = ? WHERE empresa = ?";
                if ($stmt = $mysqli->prepare($query)) {
                    $stmt->bind_param("is", $asesorId, $empresa);
                    $stmt->execute();
                }
            }
        }

        fclose($handle);
        $response["success"] = true;
        $response["message"] = "El archivo se ha procesado correctamente.";
    } else {
        $response["success"] = false;
        $response["message"] = "Error al abrir el archivo CSV.";
    }
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();  
} 

 

?>
