<?php
$r= '../';
$titlepage = "Resultados Database Clientes";
require_once($r."inc/config.php");
validSession($r);
$mysqli = connectDB($r);
$spe = $_SESSION['perfil'];
$idusuario = $_SESSION['userid'];
roleaccess(410);
include $r."inc/head.php"; ?>

<body class="fixed-nav sticky-footer sidenav-toggled bg-dark" id="page-top">
    <?php include $r."inc/nav.php"; ?>
 
    <div class="content-wrapper">
        <div class="container-fluid">
            <form id="filtroForm" class="mb-4">
  <div class="row text-white">
    <div class="col-md-2">
      <label>Tipo de filtro</label>
      <select class="form-control" name="tipo" id="tipo">
        <option value="dia">Día</option>
        <option value="semana">Semana</option>
        <option value="mes" selected>Mes</option>
        <option value="anio">Año</option>
      </select>
    </div>
    <div class="col-md-3">
      <label>Fecha</label>
      <input type="date" class="form-control" name="fecha" id="fecha">
    </div>
    <div class="col-md-2 align-self-end">
      <button type="submit" class="btn btn-primary">Filtrar</button>
    </div>
  </div>
</form>

            <h3 class="text-white">Estadísticas de llamadas</h3>
                <div class="row">
                  <div class="col-md-4 col-sm-12 mb-4">
                    <div class="card shadow mb-4">
                      <div class="card-header py-3 bg-primary">
                        <h6 class="m-0 font-weight-bold text-white">Llamadas por Agente</h6>
                      </div>
                      <div class="card-body">
                        <canvas id="llamadasPorAgente"></canvas>
                      </div>
                    </div>
                  </div>
                  
                  <div class="col-md-4 col-sm-12 mb-4">
                    <div class="card shadow mb-4">
                      <div class="card-header py-3 bg-success">
                        <h6 class="m-0 font-weight-bold text-white">Estados de Clientes</h6>
                      </div>
                      <div class="card-body">
                        <canvas id="estadosClientes"></canvas>
                      </div>
                    </div>
                  </div>
                
                  <div class="col-md-4 col-sm-12 mb-4">
                    <div class="card shadow mb-4">
                      <div class="card-header py-3 bg-info">
                        <h6 class="m-0 font-weight-bold text-white">Llamadas por Día (Última semana)</h6>
                      </div>
                      <div class="card-body">
                        <canvas id="llamadasDiarias"></canvas>
                      </div>
                    </div>
                  </div>
                </div>
                
                
<div class="card shadow mb-4">
  <div class="card-header bg-primary text-white">
    <h6 class="m-0">Llamadas por Agente (Detalle)</h6>
  </div>
  <div class="card-body p-0">
    <div class="table-responsive">
      <table class="table table-sm table-hover table-bordered mb-0 text-white bg-dark" id="tablaAgentes">
        <thead class="bg-secondary">
          <tr>
            <th>Agente</th>
            <th>Total de llamadas</th>
          </tr>
        </thead>
        <tbody>
          <!-- Se llena dinámicamente -->
        </tbody>
      </table>
    </div>
  </div>
</div>
<!-- Tabla de Estados de Clientes -->
<div class="card shadow mb-4">
  <div class="card-header bg-secondary text-white">
    <h6 class="m-0">Detalle por Estado de Llamada</h6>
  </div>
  <div class="card-body p-0">
    <div class="table-responsive">
      <table class="table table-sm table-hover table-bordered mb-0 text-white bg-dark" id="tablaEstados">
        <thead class="bg-info">
          <tr>
            <th>Estado</th>
            <th>Total</th>
          </tr>
        </thead>
        <tbody>
          <!-- Se llena con JS -->
        </tbody>
      </table>
    </div>
  </div>
</div>

<div class="card shadow mb-4">
  <div class="card-header bg-info text-white">
    <h6 class="m-0">Llamadas por Día (Detalle)</h6>
  </div>
  <div class="card-body p-0">
    <div class="table-responsive">
      <table class="table table-sm table-hover table-bordered mb-0 text-white bg-dark" id="tablaDiario">
        <thead class="bg-secondary">
          <tr>
            <th>Fecha</th>
            <th>Total de llamadas</th>
          </tr>
        </thead>
        <tbody>
          <!-- Se llena dinámicamente -->
        </tbody>
      </table>
    </div>
  </div>
</div>

        </div>
    </div>

    
  <?php include $r."inc/foot.php"; ?>
<script>
let agentesChart, estadosChart, diarioChart;

document.addEventListener("DOMContentLoaded", function () {
    const ctxAgente = document.getElementById("llamadasPorAgente").getContext('2d');
    const ctxEstados = document.getElementById("estadosClientes").getContext('2d');
    const ctxDias = document.getElementById("llamadasDiarias").getContext('2d');

    agentesChart = new Chart(ctxAgente, {
        type: 'bar',
        data: {
            labels: [],
            datasets: [{
                label: "Llamadas",
                backgroundColor: "#4e73df",
                data: []
            }]
        },
        options: { responsive: true, plugins: { legend: { display: false } } }
    });

    estadosChart = new Chart(ctxEstados, {
        type: 'bar',
        data: {
            labels: [],
            datasets: [{
                label: "Cantidad",
                data: [],
                backgroundColor: "#1cc88a"
            }]
        },
        options: {
            indexAxis: 'y',
            responsive: true,
            plugins: {
                title: {
                    display: true,
                    text: 'Estados de llamadas'
                }
            }
        }
    });

    diarioChart = new Chart(ctxDias, {
        type: 'line',
        data: {
            labels: [],
            datasets: [{
                label: "Llamadas",
                data: [],
                borderColor: "#36b9cc",
                fill: false,
                tension: 0.3
            }]
        },
        options: { responsive: true }
    });

    // Cargar por defecto (hoy)
    cargarDatos("mes", new Date().toISOString().slice(0, 10));
});

// Captura filtro
document.getElementById('filtroForm').addEventListener('submit', function (e) {
  e.preventDefault();
  const tipo = document.getElementById('tipo').value;
  const fecha = document.getElementById('fecha').value;
  cargarDatos(tipo, fecha);
});

// Función para cargar los datos
function cargarDatos(tipo, fecha) {
  fetch('datos_llamadas.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: `tipo=${tipo}&fecha=${fecha}`
  })
  .then(res => res.json())
  .then(data => actualizarGraficas(data));
}

// Actualizar gráficas y tabla
function actualizarGraficas(data) {
  // Agentes
  agentesChart.data.labels = data.agentes.map(a => a.nombre);
  agentesChart.data.datasets[0].data = data.agentes.map(a => a.total);
  agentesChart.update();

  // Estados
  estadosChart.data.labels = data.estados.map(e => e.estado);
  estadosChart.data.datasets[0].data = data.estados.map(e => e.total);
  estadosChart.update();

  // Diario
  diarioChart.data.labels = data.diario.map(d => d.fecha);
  diarioChart.data.datasets[0].data = data.diario.map(d => d.total);
  diarioChart.update();

  // Tabla de agentes
const tbodyAgentes = document.querySelector('#tablaAgentes tbody');
tbodyAgentes.innerHTML = '';
data.agentes.forEach(row => {
  tbodyAgentes.innerHTML += `<tr><td>${row.nombre}</td><td>${row.total}</td></tr>`;
});

// Tabla de estados
const tbodyEstados = document.querySelector('#tablaEstados tbody');
tbodyEstados.innerHTML = '';
data.estados.forEach(row => {
  tbodyEstados.innerHTML += `<tr><td>${row.estado}</td><td>${row.total}</td></tr>`;
});

// Tabla de días
const tbodyDiario = document.querySelector('#tablaDiario tbody');
tbodyDiario.innerHTML = '';
data.diario.forEach(row => {
  tbodyDiario.innerHTML += `<tr><td>${row.fecha}</td><td>${row.total}</td></tr>`;
});

}
</script>

</body>
</html>   