<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../vendor/PHPMailer/src/PHPMailer.php';
require '../vendor/PHPMailer/src/SMTP.php';
require '../vendor/PHPMailer/src/Exception.php';

// VARIABLES DINÁMICAS
$estimado = $_GET['estimado'] ?? 'Cliente';
$destino = $_GET['email'] ?? 'destinatario@empresa.com';

// RUTAS A LOS ARCHIVOS (puedes recibirlas por $_FILES o definirlas directamente)
$adjuntos = [
  'brochure1.pdf',
  'brochure2.pdf'
];

// CONTENIDO HTML
$contenido = '
<div style="max-width:600px; margin:auto; background:#fff; border-radius:6px; overflow:hidden; box-shadow:0 0 10px rgba(0,0,0,0.1); font-family:Arial,sans-serif;">
  <div style="background:#eee; text-align:center; padding:20px;">
    <img src="https://guiatransportes.com/app/imgs/site/logo_guia.png" alt="Logo Guiatransportes" style="max-width:180px; height:auto;">
  </div>
  <div style="padding:30px 20px; color:#333; font-size:16px; line-height:1.6;">
    <p>Estimados '.$estimado.',</p>
    <p>Desde <strong>Guiatransportes</strong> nos dirigimos a ustedes con el fin de poner a su disposición nuestro portafolio de soluciones tecnológicas orientadas al sector transporte, logística y distribución.</p>
    <p>Contamos con experiencia en el desarrollo de plataformas de gestión operativa, automatización de comunicaciones con clientes, integración de sistemas logísticos, desarrollo web a medida y herramientas especializadas para la trazabilidad de servicios.</p>
    <p>Adjuntamos un brochure donde encontrarán información más detallada sobre cada uno de nuestros servicios y cómo pueden adaptarse a sus necesidades específicas.</p>
    <p>Será un gusto para nuestro equipo poder acompañarlos en la optimización y crecimiento de sus procesos tecnológicos. Quedamos atentos para agendar una reunión en caso de que deseen ampliar la información.</p>
    <p>Atentamente,<br><strong>Equipo de Guiatransportes</strong></p>
  </div>
  <div style="background:#eee; text-align:center; padding:20px;">
    <div style="margin-bottom:10px;">
      <a href="#"><img src="https://guiatransportes.com/app/imgs/facebook.png" style="width:24px; height:24px; margin:0 8px;" alt="Facebook"></a>
      <a href="#"><img src="https://guiatransportes.com/app/imgs/linkedin.png" style="width:24px; height:24px; margin:0 8px;" alt="LinkedIn"></a>
      <a href="#"><img src="https://guiatransportes.com/app/imgs/instagram.png" style="width:24px; height:24px; margin:0 8px;" alt="Instagram"></a>
    </div>
    <div style="font-size:14px; color:#4483a0;">
      Guiatransportes<br>www.guiatransportes.com • info@guiatransportes.com • +57 123 456 7890
    </div>
  </div>
</div>';

// ENVÍO CON PHPMailer
$mail = new PHPMailer(true);

try {
    // CONFIGURACIÓN BÁSICA
    $mail->isSMTP();
    $mail->SMTPAuth = true;
    $mail->Host = 'smtp1.s.ipzmarketing.com'; // Utiliza el servidor SMTP
    $mail->Username = 'dojmroqyzakw'; // Tu dirección de correo electrónico
    $mail->Password = '1vCyMmchZxwe'; // Tu contraseña de correo electrónico
    $mail->SMTPSecure = 'tls';
    $mail->Port = 587;

    $mail->setFrom('soporte@guiatransportes.com', 'Guiatransportes');
    $mail->addAddress($destino);

    // CONTENIDO
    $mail->isHTML(true);
    $mail->Subject = 'Presentación de Servicios - Guiatransportes';
    $mail->Body = $contenido;

    // ADJUNTAR ARCHIVOS
    foreach ($adjuntos as $archivo) {
        if (file_exists($archivo)) {
            $mail->addAttachment($archivo);
        }
    }

    // ENVÍO
    $mail->send();
    echo "✅ Correo enviado correctamente a $destino.";
} catch (Exception $e) {
    echo "❌ Error al enviar el correo. {$mail->ErrorInfo}";
}
