<?php


use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;


/* funcion connectDB -> CONEXION BASE DE DATOS*/
function connectDB($r) {
  global $server, $bduser, $bdpass, $bdname, $bdport;
  $mysqli = new mysqli($server, $bduser, $bdpass, $bdname, $bdport);
  if($mysqli->connect_error) {
    $error = str_replace("'", "", $mysqli->connect_error); 
    exit(header("Location:".$r."index.php?error=fallo la conexion (".$error.")"));
  } else {
    $mysqli->query("SET NAMES 'utf8'");
    return $mysqli;
  }
}

/* funcion validSession -> VEREFICA QUE LA SESSION ESTE INICIADA*/
function validSession($r) {
    global $ruta_app;
    session_start();
    if(!isset($_SESSION['userid'])) {
        exit(header("Location: ".$ruta_app."index.php?error=Primero debe iniciar sesion"));
    } 
}

/* funcion validNotSession -> VERIFICA QUE LA SESSION NO ESTE INICIADA*/
function validNotSession($r) {
    session_start();
    if($_SESSION["userid"]) {
        exit(header("Location:".$ruta_app."dashboard.php"));
    }
}

function sinfo($id,$tabla) {
    global $mysqli;
    // Ejecutar la consulta para obtener los datos
    $row1 = $mysqli->query("SELECT * FROM $tabla WHERE id='$id'");

    // Verificar si la consulta se ejecutó correctamente y si se encontraron registros
    if(!$row1 || $row1->num_rows == 0) {
        return null;
    }

    // Obtener los datos
    $datos = $row1->fetch_assoc();
    return $datos;
}

function moneda($valor){
    global $currencysign, $currency;
    return $currencysign.' '.number_format($valor).' '.$currency;
}


function generarCodigo($longitud) {
     $key = "";
     $pattern = '1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
     $max = strlen($pattern)-1;
     for($i=0;$i < $longitud;$i++) $key .= $pattern{mt_rand(0,$max)};
     return $key;
}  

function clave($contraseña){
    return password_hash($contraseña, PASSWORD_BCRYPT);
}


function clearstr($str){
    global $mysqli;
    $str = strtoupper($str);
    mysqli_real_escape_string($mysqli, $str);
    return $str; 
}

function roleaccess($idpag){
    global $mysqli , $spe , $r;
    $sqlroles = $mysqli->query("SELECT `sigla` FROM `z_usuarios_perfiles` WHERE `id` = $spe");
    $rowroles = $sqlroles->fetch_assoc();
    $psigla=$rowroles['sigla'];
    $sqlrole = $mysqli->query("SELECT * FROM z_usuarios_permisos WHERE id=$idpag");
    $rowrole = $sqlrole->fetch_assoc();
    if($rowrole[$psigla]==0){
        exit(header("Location:".$r."index.php?error=NO TINES ACCESSO A ESTA AREA"));
    }
}

function viewroleaccess($idpag){
    global $mysqli , $spe , $r;
    $sqlroles = $mysqli->query("SELECT `sigla` FROM `z_usuarios_perfiles` WHERE `id` = $spe");
    $rowroles = $sqlroles->fetch_assoc();
    $psigla=$rowroles['sigla'];
    $sqlrole = $mysqli->query("SELECT * FROM z_usuarios_permisos WHERE id=$idpag");
    $rowrole = $sqlrole->fetch_assoc();
    if($rowrole[$psigla]==0){return FALSE;}else{return TRUE;}
}

function viewroleaccessuser($idpag){
    global $mysqli , $spe , $r;
    $sqlroles = $mysqli->query("SELECT sigla FROM z_usuarios_perfiles WHERE id=$spe");
    $rowroles = $sqlroles->fetch_assoc();
    $psigla=$rowroles['sigla'];
    $sqlrole = $mysqli->query("SELECT * FROM z_usuarios_permisos WHERE id=$idpag");
    $rowrole = $sqlrole->fetch_assoc();
    if($rowrole[$psigla]==0){return FALSE;}else{return TRUE;}
    
}
function viewmultiroleaccess($idpags){
    global $mysqli , $spe , $r;
    $true=0;
    $sqlroles = $mysqli->query("SELECT sigla FROM z_usuarios_perfiles WHERE id=$spe");
    $rowroles = $sqlroles->fetch_assoc();
    $psigla=$rowroles['sigla'];
    foreach ($idpags as $valor) {
        $sqlrole = $mysqli->query("SELECT $psigla FROM z_usuarios_permisos WHERE id=$valor");
        $rowrole = $sqlrole->fetch_assoc();
        if($rowrole[$psigla]==1){$true=1;}
    }
    if($true!=1){return FALSE;}else{return TRUE;}
}


function getRealIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP']))
        return $_SERVER['HTTP_CLIENT_IP'];
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
    return $_SERVER['REMOTE_ADDR'];
}

function loadimagen($archivo,$nombre,$ruta){
      $errors= array();
      $file_name = $archivo['name'];
      $file_size = $archivo['size'];
      $file_tmp = $archivo['tmp_name'];
      $file_type = $archivo['type'];
      $file_ext = strtolower(end(explode('.',$archivo['name'])));
      $target_path1=$nombre.'.'.$file_ext;
      if($file_size > 120000000){
         $errors[]='El tamaño del archivo debe ser de 4 MB maximo';
      }
      if(empty($errors)==true){
         move_uploaded_file($file_tmp,$_SERVER['DOCUMENT_ROOT'].$ruta.$target_path1);
            $srcfile=$_SERVER['DOCUMENT_ROOT'].$ruta.$target_path1;
            $dstfile=$_SERVER['DOCUMENT_ROOT'].$ruta.'sm/'.$target_path1;
            //mkdir(dirname($dstfile), 0777, true);
            copy($srcfile, $dstfile);
         
         // Fichero y nuevo tamaños
        $nombre_fichero = $_SERVER['DOCUMENT_ROOT'].$ruta.'sm/'.$target_path1;
        
        // Obtener los nuevos tamaños
        list($ancho, $alto) = getimagesize($nombre_fichero);
        $imagen = getimagesize($nombre_fichero);
        $nuevo_ancho = $imagen[0]/2;
        $nuevo_alto = $imagen[1]/2;
        
        // Cargar
        $thumb = imagecreatetruecolor($nuevo_ancho, $nuevo_alto);
        
        $fondo = imagecolorallocate($thumb, 255, 255, 255);
        $ct  = imagecolorallocate($thumb, 0, 0, 0);

        imagefilledrectangle($thumb, 0, 0, $nuevo_ancho, $nuevo_alto, $fondo);
        
        /* Imprimir un mensaje de error */
        //imagestring($thumb, 5, 5, 5, 'Error cargando ' . $file_name, $ct);
        
        
        if($file_ext=="jpg" || $file_ext=="jpeg"){
            $origen = @imagecreatefromjpeg($nombre_fichero);
            // Cambiar el tamaño
            imagecopyresized($thumb, $origen, 0, 0, 0, 0, $nuevo_ancho, $nuevo_alto, $ancho, $alto);
            // Imprimir
            imagejpeg($thumb, $nombre_fichero, 50);
        }else{
            $origen = @imagecreatefrompng($nombre_fichero);
            // Cambiar el tamaño
            imagecopyresized($thumb, $origen, 0, 0, 0, 0, $nuevo_ancho, $nuevo_alto, $ancho, $alto);
            
            // Imprimir
            imagepng($thumb, $nombre_fichero, 4);
         
        }
      }else{
        return FALSE;
        exit();
      }
    return $target_path1;
    exit();
} 

function loadfile($archivo, $nombre, $ruta) {
    $file_ext = explode('.', $archivo['name']);
    $file_ext = end($file_ext);
    $file_ext = strtolower($file_ext);
    $target_path1 = $nombre . '.' . $file_ext;
    
    if (move_uploaded_file($archivo['tmp_name'],  $ruta . $target_path1)) {
        return $ruta.$target_path1;
    } else {
        // Imprimir el mensaje de error para depuración
        echo "Error al mover el archivo. Debugging: " . $archivo['error'];
        return FALSE;
    }
}


function loadfiles($archivo,$key,$nombre,$ruta){
      $file_ext = strtolower(end(explode('.',$archivo['name'][$key])));
      $target_path1=$nombre.'.'.$file_ext;
    if (move_uploaded_file($archivo['tmp_name'][$key],$_SERVER['DOCUMENT_ROOT'].$ruta.$target_path1)) {
        return $target_path1;
    } else {
        return FALSE;
    }
}


function msgerror($error){
    $json[] = array('accion'=>'alert','tipo'=>'alert-warning','msg'=>'Upps, a ocorrido un error '.$error.' pongase en contacto con su administrador si el problema persiste');
    echo json_encode($json);
    exit();
}

function codigorandom($strength) {
    $input = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $input_length = strlen($input);
    $random_string = '';
    for($i = 0; $i < $strength; $i++) {
        $random_character = $input[mt_rand(0, $input_length - 1)];
        $random_string .= $random_character;
    }
    return $random_string;
}


// Importar las clases necesarias de PHPMailer
require_once("/home/grupoael/guiatransportes.com/app/vendor/PHPMailer/src/PHPMailer.php");
require_once("/home/grupoael/guiatransportes.com/app/vendor/PHPMailer/src/SMTP.php");
require_once("/home/grupoael/guiatransportes.com/app/vendor/PHPMailer/src/Exception.php");


// Definir la función phpmailer
function phpmailer($para, $asunto, $mensaje) {
    global $headermail,$footmail;
    
    $mail = new PHPMailer(true);

    // Configurar el servidor SMTP
    $mail->isSMTP();
    $mail->SMTPAuth = true;
    $mail->SMTPSecure = 'tls'; // Utiliza 'tls' para STARTTLS
    $mail->Port = '587'; 
    
    $mail->Host = 'smtp1.s.ipzmarketing.com'; // Utiliza el servidor SMTP
    $mail->Username = 'dojmroqyzakw'; // Tu dirección de correo electrónico
    $mail->Password = '1vCyMmchZxwe'; // Tu contraseña de correo electrónico
    
    // Habilitar la depuración en nivel 2
    //$mail->SMTPDebug = 2;

    // Configurar remitente y destinatario
    $mail->setFrom('info@guiatransportes.com', 'Soporte Guiatransportes');
    $mail->addAddress($para);

    // Contenido del correo electrónico
    $mail->isHTML(true);
    $mail->Subject = $asunto;
    $mail->Body    = $headermail . $mensaje . $footmail;

    // Enviar el correo electrónico
    $mail->send();
    
}

function enviarEmail($para, $assunto, $mensagem) {
    global $headermail,$footmail;
    $remetente = 'info@guiatransportes.com';
    $nomeRemetente = 'soporte';
    // Configurações do cabeçalho do e-mail
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

    // Cabeçalhos adicionais
    $headers .= "From: " . $nomeRemetente . " <" . $remetente . ">\r\n";
    $headers .= "Reply-To: " . $remetente . "\r\n";
    $headers .= "Return-Path: " . $remetente . "\r\n";
    $headers .= "X-Mailer: PHP/" . phpversion() . "\r\n";
    $headers .= "X-Originating-IP: " . $_SERVER['SERVER_ADDR'] . "\r\n";

    // Adicione cabeçalhos adicionais, como:
    // $headers .= "List-Unsubscribe: <mailto:unsubscribe@example.com>\r\n";

    // Evitar que o e-mail seja marcado como spam
    /*$headers .= "Precedence: bulk\r\n";
    $headers .= "List-Unsubscribe: <mailto:unsubscribe@example.com>\r\n";
    $headers .= "List-Help: <mailto:help@example.com>\r\n";
    $headers .= "List-Subscribe: <mailto:subscribe@example.com>\r\n";
    $headers .= "List-Owner: <mailto:owner@example.com>\r\n";
    $headers .= "List-Post: <mailto:post@example.com>\r\n";*/

    // Adicione a palavra-chave [SPAM] ao assunto para ajudar os filtros de spam
    $assunto = $assunto;
    $mensagem = $headermail.$mensagem.$footmail;
    // Envie o e-mail
    return mail($para, $assunto, $mensagem, $headers);
}

    
function fechaspanish ($fecha) {
  $fecha = substr($fecha, 0, 10);
  $numeroDia = date('d', strtotime($fecha));
  $dia = date('l', strtotime($fecha));
  $mes = date('F', strtotime($fecha));
  $anio = date('Y', strtotime($fecha));
  $dias_ES = array("Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado", "Domingo");
  $dias_EN = array("Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday");
  $nombredia = str_replace($dias_EN, $dias_ES, $dia);
  $meses_ES = array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
  $meses_EN = array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
  $nombreMes = str_replace($meses_EN, $meses_ES, $mes);
  return $nombredia." ".$numeroDia." de ".$nombreMes." de ".$anio;
}

function codigoQR($nombre,$tamaño,$level,$framSize,$contenido){
	//Cuando se llame la funcion agregar  la libreria para genera códigos QR qrlib.php"
	require($_SERVER['DOCUMENT_ROOT']."/vendor/phpqrcode/qrlib.php");  
	//Declaramos una carpeta temporal para guardar la imagenes generadas
	$dir = $_SERVER['DOCUMENT_ROOT'].'/acciones/codigosQR/';
	
	//Si no existe la carpeta la creamos
	if (!file_exists($dir)){
        mkdir($dir, 0777, true);
    }
	
        //Declaramos la ruta y nombre del archivo a generar
	$filename = $dir.$nombre;
 
        //Parametros de Condiguración
	
        //Enviamos los parametros a la Función para generar código QR 
	QRcode::png($contenido, $filename, $level, $tamaño, $framSize); 
	
        //Mostramos la imagen generada
	//echo '<img src="'.$dir.basename($filename).'" /><hr/>';  
}

function enviarCorreoGuiatransportes($empresa, $correo, $adjuntos = []) {

    $estimado = $empresa;
    $destino = $correo;

    $contenido = '
    <div style="max-width:600px; margin:auto; background:#fff; border-radius:6px; overflow:hidden; box-shadow:0 0 10px rgba(0,0,0,0.1); font-family:Arial,sans-serif;">
      <div style="background:#eee; text-align:center; padding:20px;">
        <img src="https://guiatransportes.com/app/imgs/site/logo_guia.png" alt="Logo Guiatransportes" style="max-width:180px; height:auto;">
      </div>
      <div style="padding:30px 20px; color:#333; font-size:16px; line-height:1.6;">
        <p>Estimados '.$estimado.',</p>
        <p>Desde <strong>Guiatransportes</strong> nos dirigimos a ustedes con el fin de poner a su disposición nuestro portafolio de soluciones tecnológicas orientadas al sector transporte, logística y distribución.</p>
        <p>Contamos con experiencia en el desarrollo de plataformas de gestión operativa, automatización de comunicaciones con clientes, integración de sistemas logísticos, desarrollo web a medida y herramientas especializadas para la trazabilidad de servicios.</p>
        <p>Adjuntamos un brochure donde encontrarán información más detallada sobre cada uno de nuestros servicios y cómo pueden adaptarse a sus necesidades específicas.</p>
        <p>Será un gusto para nuestro equipo poder acompañarlos en la optimización y crecimiento de sus procesos tecnológicos. Quedamos atentos para agendar una reunión en caso de que deseen ampliar la información.</p>
        <p>Atentamente,<br><strong>Equipo de Guiatransportes</strong></p>
      </div>
      <div style="background:#eee; text-align:center; padding:20px;">
        <div style="margin-bottom:10px;">
          <a href="#"><img src="https://guiatransportes.com/app/imgs/facebook.png" style="width:24px; height:24px; margin:0 8px;" alt="Facebook"></a>
          <a href="#"><img src="https://guiatransportes.com/app/imgs/linkedin.png" style="width:24px; height:24px; margin:0 8px;" alt="LinkedIn"></a>
          <a href="#"><img src="https://guiatransportes.com/app/imgs/instagram.png" style="width:24px; height:24px; margin:0 8px;" alt="Instagram"></a>
        </div>
        <div style="font-size:14px; color:#4483a0;">
          Guiatransportes<br>www.guiatransportes.com • info@guiatransportes.com • +57 123 456 7890
        </div>
      </div>
    </div>';

    try {
        $mail = new PHPMailer(true);
        $mail->isSMTP();
        $mail->CharSet = 'UTF-8';
        $mail->Encoding = 'base64';
        $mail->SMTPAuth = true;
        $mail->Host = $GLOBALS['MAIL_HOST'];
        $mail->Username = $GLOBALS['MAIL_USER'];
        $mail->Password = $GLOBALS['MAIL_PASS'];
        $mail->SMTPSecure = $GLOBALS['MAIL_SECURE'];
        $mail->Port = $GLOBALS['MAIL_PORT'];

        $mail->setFrom('info@guiatransportes.com', 'Guiatransportes');
        $mail->addAddress($destino);

        $mail->isHTML(true);
        $mail->Subject = 'Presentación de Servicios - Guiatransportes';
        $mail->Body = $contenido;

        foreach ($adjuntos as $archivo) {
            if (file_exists($archivo)) {
                $mail->addAttachment($archivo);
            } else {
                error_log("Archivo no encontrado: " . $archivo);
            }
        }

        $mail->send();
        return ['success' => true, 'message' => 'Correo enviado correctamente.'];
    } catch (Exception $e) {
        return ['success' => false, 'message' => 'Error al enviar el correo: ' . $mail->ErrorInfo];
    }
}

?>