<?php
$r= '../';
require_once($r."inc/config.php");
$mysqli = connectDB($r);


if(isset($_POST['infoproducto'])){
    $idproducto = $_POST['infoproducto'];
    $infoproducto = sinfo($idproducto,'z_productos');
    if ($idproducto) {
        $response['success'] = true;
        $response['data'] = $infoproducto; // La página a la que quieres redirigir en caso de éxito
    } else {
        $response['success'] = false;
        $response['message'] = 'fallo algo'; // Puedes proporcionar un mensaje de error específico
    }
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}

if(isset($_POST['infocode'])){
    $sql = "SHOW TABLE STATUS LIKE 'z_productos'";
    $result = $mysqli->query($sql);

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $next_id = $row['Auto_increment']+1;
       
        $response['success'] = true;
        $response['message'] = "GT-2024-" . $next_id; // Puedes proporcionar un mensaje de error específico
        
        header('Content-Type: application/json');
        echo json_encode($response);
        exit();
    }
}


if(isset($_POST['ActionProducto'])){

   
   $uploadDir = 'uploads/'; // Carpeta donde se almacenarán los archivos subidos

    // Obtener la extensión del archivo
    $fileExtension = pathinfo($_FILES['imagen_producto']['name'], PATHINFO_EXTENSION);
    
    // Generar un nombre de archivo basado en la fecha Unix
    $newFileName = time() . '.' . $fileExtension;
    $uploadFile = $uploadDir . $newFileName;
    
    // Verificar si el archivo ya existe
    if (file_exists($uploadFile)) {
        // Si el archivo ya existe, generar un nuevo nombre único
        $newFileName = time() . '-' . uniqid() . '.' . $fileExtension;
        $uploadFile = $uploadDir . $newFileName;
    }
    
    // Verificar si el archivo fue cargado sin errores
    if (isset($_FILES['imagen_producto']) && $_FILES['imagen_producto']['error'] == UPLOAD_ERR_OK) {
        // Verificar el tipo de archivo (opcional)
        $fileType = mime_content_type($_FILES['imagen_producto']['tmp_name']);
        if (strpos($fileType, 'image') === false) {
            $response['success'] = false;
            $response['message'] = 'El archivo no es una imagen.';
            $newFileName = 'sin_imagen.png';
        }
    
        // Mover el archivo al directorio de destino
        move_uploaded_file($_FILES['imagen_producto']['tmp_name'], $uploadFile);
        
    } else {
        $newFileName = 'sin_imagen.png';
    }
   
    $nombre = isset($_POST['nota']) ? $_POST['nota'] : '';
    $codigo = $_POST['codigo'];
    $precio = $_POST['precio'];
    $no_parte = $_POST['no_parte'];
    $tipo = isset($_POST['tipo']) ? $_POST['tipo'] : '';
    $equipo = isset($_POST['equipo']) ? $_POST['equipo'] : '';
    $modulo = isset($_POST['modulo']) ? $_POST['modulo'] : '';
    $nota = isset($_POST['nota']) ? $_POST['nota'] : '';
    $modelo = $_POST['modelo'];
    $stock = isset($_POST['stock']) ? $_POST['stock'] : '';
    $idempresa = isset($_POST['cliente']) ? $_POST['cliente'] : '';
    $serial = isset($_POST['serial']) ? $_POST['serial'] : '';

    // Prevenir inyección SQL y preparar consultas
    $codigo = $mysqli->real_escape_string($codigo);
    $nombre = $mysqli->real_escape_string($nombre);
    $precio = $mysqli->real_escape_string($precio);
    $nota = $mysqli->real_escape_string($nota);
    $stock = $mysqli->real_escape_string($stock);
    if(!isset($modelo)){ $modelo = $mysqli->real_escape_string($modelo);}
    $idempresa = $mysqli->real_escape_string($idempresa);
    $serial = $mysqli->real_escape_string($serial);

    if (empty($_POST['ActionProducto'])) {
        // Nuevo Producto
        if ($codigo && $nombre && $stock && $idempresa) {
            // Verificar si el código del producto ya existe
            $check_query = $mysqli->prepare("SELECT COUNT(*) FROM `z_productos` WHERE `codigo` = ?");
            $check_query->bind_param("s", $codigo);
            $check_query->execute();
            $check_query->bind_result($count);
            $check_query->fetch();
            $check_query->close();
    
            if ($count > 0) {
                // El código del producto ya existe
                $response['success'] = false;
                $response['message'] = 'El código del producto ya existe en la base de datos';
            } else {
                // El código del producto es único, proceder con la inserción
                $query = $mysqli->prepare("INSERT INTO `z_productos`( `imagen`, `codigo`, `producto`, `no_parte`, `equipo`, `tipo`, `nota`, `modulo`, `modelo`, `serial`, `precio`, `stock`, `id_empresa`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $query->bind_param("ssssiissssiii", $newFileName, $codigo, $nombre, $no_parte, $equipo, $tipo, $nota, $modulo, $modelo, $serial, $precio, $stock, $idempresa);

                if ($query->execute()) {
                    $response['success'] = true;
                    $response['message'] = 'En hora Buena, Producto se ha creado'; 
                } else {
                    $response['success'] = false;
                    $response['message'] = 'Ha ocurrido un error, El producto no pudo ser creado: ' . $mysqli->error;
                }
                $query->close();
            }
        } else {
            $response['success'] = false;
            $response['message'] = 'Faltan datos, El producto no pudo ser creado';
        }
    } else {
        // Actualizar Producto
        $idproducto = $_POST['ActionProducto'];
        
        if ($idproducto && $codigo && $nombre && $stock && $idempresa) {
            
            // Verificar si el código del producto ya existe
            $check_query = $mysqli->prepare("SELECT COUNT(*) FROM `z_productos` WHERE `codigo` = ? AND `id` != ?");
            $check_query->bind_param("si", $codigo, $idproducto);

            $check_query->execute();
            $check_query->bind_result($count);
            $check_query->fetch();
            $check_query->close();
    
            if ($count > 0) {
                // El código del producto ya existe
                $response['success'] = false;
                $response['message'] = 'El código del producto ya existe para otro producto en la base de datos';
            } else {
                $query = $mysqli->prepare("UPDATE `z_productos` SET `imagen`=?, `codigo`=?, `producto`=?, `no_parte`=?, `equipo`=?, `tipo`=?, `nota`=?, `precio`=?, `stock`=?, `serial`=?, `modulo`=?, `modelo`=?, `id_empresa`=? WHERE `id`=?");
                $query->bind_param("sssssssiisiiii", $newFileName, $codigo, $nombre, $no_parte, $equipo, $tipo, $nota, $precio, $stock, $serial, $modulo, $modelo, $idempresa, $idproducto);

                if ($query->execute()) {
                    $response['success'] = true;
                    $response['message'] = 'En hora Buena, Producto se ha actualizado'; 
                } else {
                    $response['success'] = false;
                    $response['message'] = 'Ha ocurrido un error, El producto no pudo ser actualizado: ' . $mysqli->error;
                }
                $query->close();
            }
        } else {
            $response['success'] = false;
            $response['message'] = 'Faltan datos, El producto no pudo ser actualizado';
        }
    }
    $mysqli->close(); // Cierra la conexión
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}



if(isset($_POST['ActionItem'])){
    $action = $_POST['ActionItem'];
    $nameitem = $_POST['nameitem'];
    switch ($action) {
        case 'tipo':
            // Lógica para 'tipo'
            $mysqli->query("INSERT INTO `z_productos_tipos`( `tipo`) VALUES ('$nameitem')");
            break;
    
        case 'equipo':
            // Lógica para 'equipo'
            $mysqli->query("INSERT INTO `z_productos_equipos`( `equipo`) VALUES ('$nameitem')");
            break;
    
        case 'modelo':
            // Lógica para 'modelo'
            $mysqli->query("INSERT INTO `z_productos_modelos`( `modelo`) VALUES ('$nameitem')");
            break;
    
        case 'modulo':
            // Lógica para 'modulo'
            $mysqli->query("INSERT INTO `z_productos_modulos`( `modulos`) VALUES ('$nameitem')");
            break;
    }

    /*$idproducto = $_POST['estado'];
    $infoproducto = sinfo($idproducto,'z_productos');
    if ($infoproducto['estado']) {
        $mysqli->query("UPDATE `z_productos` SET `estado` = '0' WHERE `z_productos`.`id` = $idproducto");
        $response['success'] = true;
        $response['message'] = 'Desactivado '; // La página a la que quieres redirigir en caso de éxito
    } else {
        $mysqli->query("UPDATE `z_productos` SET `estado` = '1' WHERE `z_productos`.`id` = $idproducto");
        $response['success'] = true;
        $response['message'] = 'Activado'; // Puedes proporcionar un mensaje de error específico
    }
    header('Content-Type: application/json');
    
    echo json_encode($response);*/
    print_r($_POST);
    exit();
}

if(isset($_POST['estado'])){
    $idproducto = $_POST['estado'];
    $infoproducto = sinfo($idproducto,'z_productos');
    if ($infoproducto['estado']) {
        $mysqli->query("UPDATE `z_productos` SET `estado` = '0' WHERE `z_productos`.`id` = $idproducto");
        $response['success'] = true;
        $response['message'] = 'Desactivado '; // La página a la que quieres redirigir en caso de éxito
    } else {
        $mysqli->query("UPDATE `z_productos` SET `estado` = '1' WHERE `z_productos`.`id` = $idproducto");
        $response['success'] = true;
        $response['message'] = 'Activado'; // Puedes proporcionar un mensaje de error específico
    }
    header('Content-Type: application/json');
    
    echo json_encode($response);
    exit();
}

if(isset($_POST['eliminar'])){
    $idproducto = $_POST['eliminar'];
    $infoproducto = sinfo($idproducto,'z_productos');
    $mysqli->query("UPDATE `z_productos` SET `eliminado` = '1' WHERE `z_productos`.`id` = $idproducto");
    $response['success'] = true;
    $response['message'] = 'Producto Eliminado '; 
    header('Content-Type: application/json');
    
    echo json_encode($response);
    exit();
}
