<?php
$r= '../';
$titlepage='CONFIGURACION BODEGA';
require_once($r."inc/config.php");
validSession($r);
$mysqli = connectDB($r);
$spe = $_SESSION['perfil'];
$idusuario = $_SESSION['userid'];
roleaccess(440);
include $r."inc/head.php"; ?>

<body class="fixed-nav sticky-footer sidenav-toggled bg-dark" id="page-top">
    <?php include $r."inc/nav.php"; ?>
 
    <div class="content-wrapper">
  <div class="container-fluid">
    <!-- Tabs Navigation -->
    <ul class="nav nav-tabs" id="tabMenu" role="tablist">
      <li class="nav-item">
        <a class="nav-link active" id="tipos-tab" data-toggle="tab" href="#tipos" role="tab" aria-controls="tipos" aria-selected="true">TIPOS</a>
      </li>
      <li class="nav-item">
        <a class="nav-link" id="equipos-tab" data-toggle="tab" href="#equipos" role="tab" aria-controls="equipos" aria-selected="false">EQUIPOS</a>
      </li>
      <li class="nav-item">
        <a class="nav-link" id="modulos-tab" data-toggle="tab" href="#modulos" role="tab" aria-controls="modulos" aria-selected="false">MODULOS</a>
      </li>
      <li class="nav-item">
        <a class="nav-link" id="modelos-tab" data-toggle="tab" href="#modelos" role="tab" aria-controls="modelos" aria-selected="false">MODELOS</a>
      </li>
    </ul>

    <!-- Tabs Content -->
    <div class="tab-content" id="tabContent">
      <!-- TIPOS -->
      <div class="tab-pane fade show active" id="tipos" role="tabpanel" aria-labelledby="tipos-tab">
        <div class="card">
          <div class="card-header h3">
            <i class="fa fa-table"></i> TIPOS
            <? if(viewroleaccess(441)){ ?><a class="btn text-success float-right p-0 ml-3" onclick="newitem('tipo')" title="Nueva Tipo"><i class="fa fa-plus-circle fa-2x"></i></a><? } ?>
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-bordered table-striped" id="tipo" data-ajax="server_side/tipos.php" width="100%" cellspacing="0">
                <thead>
                  <tr>
                    <th>Tipos</th>
                    <th style="width:40px"></th>
                  </tr>
                </thead>
              </table>
            </div>
          </div>
        </div>
      </div>

      <!-- EQUIPOS -->
      <div class="tab-pane fade" id="equipos" role="tabpanel" aria-labelledby="equipos-tab">
        <div class="card">
          <div class="card-header h3">
            <i class="fa fa-table"></i> EQUIPOS
            <? if(viewroleaccess(441)){ ?><a class="btn text-success float-right p-0 ml-3" onclick="newitem('equipo')" title="Nueva Equipo"><i class="fa fa-plus-circle fa-2x"></i></a><? } ?>
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-bordered table-striped" id="equipo" data-ajax="server_side/equipos.php" width="100%" cellspacing="0">
                <thead>
                  <tr>
                    <th>Equipos</th>
                    <th style="width:40px"></th>
                  </tr>
                </thead>
              </table>
            </div>
          </div>
        </div>
      </div>

      <!-- MODULOS -->
      <div class="tab-pane fade" id="modulos" role="tabpanel" aria-labelledby="modulos-tab">
        <div class="card">
          <div class="card-header h3">
            <i class="fa fa-table"></i> MODULOS
            <? if(viewroleaccess(441)){ ?><a class="btn text-success float-right p-0 ml-3" onclick="newitem('modulo')" title="Nuevo Modulo"><i class="fa fa-plus-circle fa-2x"></i></a><? } ?>
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-bordered table-striped" data-ajax="server_side/modulos.php" id="modulo" width="100%" cellspacing="0">
                <thead>
                  <tr>
                    <th>Modulos</th>
                    <th style="width:40px"></th>
                  </tr>
                </thead>
              </table>
            </div>
          </div>
        </div>
      </div>

      <!-- MODELOS -->
      <div class="tab-pane fade" id="modelos" role="tabpanel" aria-labelledby="modelos-tab">
        <div class="card">
          <div class="card-header">
            <i class="fa fa-table h3"></i> MODELOS
            <? if(viewroleaccess(441)){ ?><a class="btn text-success float-right p-0 ml-3" onclick="newitem('modelo')" title="Nuevo Modelo"><i class="fa fa-plus-circle fa-2x"></i></a><? } ?>
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-bordered table-striped" data-ajax="server_side/modelos.php" id="modelo" width="100%" cellspacing="0">
                <thead>
                  <tr>
                    <th>Modelos</th>
                    <th style="width:40px"></th>
                  </tr>
                </thead>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

      
  
    <!-- Modal Nuevo Item-->
    <div class="modal fade" id="crearitem" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">Crear <span id="titleitem"></span></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <form id="newformulario1" class="newformulario"  action="acciones.php" method="POST" data-modal="crearitem" data-table="dataTable1">
              <input type="hidden" name="ActionItem">
              <div class="form-group">
                <label id="labelitem"></label>
                <input type="text" name="nameitem" class="form-control" placeholder="Ingrese" required>
              </div>
            </form>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRAR</button>
            <button type="submit" form="newformulario1" class="btn btn-primary">GUARDAR</button>
          </div>
        </div>
      </div>
    </div>
    
    <!-- Modal Editar Item-->
    <div class="modal fade" id="editaritem" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">Editar <span id="titleitemedit"></span></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <form id="editform" class="newformulario"  action="acciones.php" method="POST" data-modal="editaritem" data-table="dataTable1">
              <input type="hidden" name="ActionEdit">
              <div class="form-group">
                <label id="labelitemedit"></label>
                <input type="hidden" name="iditemedit">
                <input type="text" name="nameitemedit" class="form-control" placeholder="Ingrese" required>
              </div>
            </form>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRAR</button>
            <button type="submit" form="editform" class="btn btn-primary">GUARDAR</button>
          </div>
        </div>
      </div>
    </div>
    
  <?php include $r."inc/foot.php"; ?>
  <script>
    $(document).ready(function(){
        $(".dataTable").each(function(){
            $(this).DataTable();
        });
        $('.newformulario').on('submit', function(e) {
            var form = $(this);
            var idTabla= form.attr('data-table'); // O el método que estés utilizando en tu formulario
            var idModal= form.attr('data-modal');
            // Evita el comportamiento predeterminado de envío del formulario
            e.preventDefault();
            
            // Obtén los datos del formulario
            var formData = $(this).serialize();
            
            // Realiza la solicitud Ajax
            $.ajax({
              type: form.attr('method'), // O el método que estés utilizando en tu formulario
              url: form.attr('action'), // La URL a la que quieres enviar los datos
              data: formData, // Los datos del formulario serializados
              dataType:'json',
              success: function(response) {
                // Maneja la respuesta del servidor si es necesario
                if (response.success) {
                    console.log("#" + idTabla);
                    $("#" + idTabla).DataTable().ajax.reload();
                    $('#' + idModal).modal('hide');
                    form[0].reset();
                    swal(response.message);
                } else {
                    // Mostrar un mensaje de error en algún lugar del formulario
                    swal(response.message);
                }
              },
              error: function(xhr, status, error) {
                // Maneja cualquier error que pueda ocurrir durante la solicitud
                console.error('Error en la solicitud:', error);
              }
            });
        });
    });

    
    configurarDataTable('tipo');
    configurarDataTable('equipo');
    configurarDataTable('modelo');
    configurarDataTable('modulo');
    
    function configurarDataTable(idTabla) {
        $('#' + idTabla).DataTable({
            "processing": true,
            "serverSide": true,
            "ajax": $('#' + idTabla).data('ajax'),
            // Otras configuraciones...
        });
    }

    function newitem(modal){
        $('.newformulario')[0].reset();
        $('input[name=ActionItem]').val(modal);
        $('#titleitem, #labelitem').html(modal);
        $('input[name=nameitem]').attr('placeholder','Ingrese '+modal);
        $('#newformulario1').attr('data-table', modal);
        $('#crearitem').modal('show');
    }
    
    function editaritem(id,tipo){
        $('#editform').attr('data-table', tipo);
        $.post( "acciones.php", { infoitem: id, tipo: tipo })
          .done(function( response ) {
            if (response.success) {
                $('#editaritem').modal('show');
                $('input[name=ActionEdit]').val(tipo);
                $('input[name=iditemedit]').val(id);
                $('#titleitemedit, #labelitemedit').html(tipo);
                $('input[name=nameitem]').attr('placeholder','Ingrese '+tipo);
                $('input[name=nameitemedit]').val(response.data.item);
            } else {
                // Mostrar un mensaje de error en algún lugar del formulario
                $("#error-message").html(response.message);
            }
        });
    }
    
    function eliminaritem(id,tipo){
         swal({
            title: '¿Deseas eliminar '+tipo+'?',
            text: 'Estas apunto de eliminar '+tipo+'. Esta acción no se puede deshacer. estas seguro?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar',
            closeOnConfirm: false,
            closeOnCancel: true
        }, function(isConfirm) {
            if (isConfirm) {
                $.post( "acciones.php", { elimaritem: id, tipo: tipo })
              .done(function( response ) {
                if (response.success) {
                    
                    $("#"+tipo).DataTable().ajax.reload();
                    swal('Restaurado', 'El '+tipo+' se elimino.', 'success');
                } else {
                    // Mostrar un mensaje de error en algún lugar del formulario
                    $("#error-message").html(response.message);
                }
            });
            }
        });
        
    }
  </script>
</body>
</html>   