<?php
$r= '../';
$titlepage='EMPRESAS';
require_once($r."inc/config.php");
validSession($r);
$mysqli = connectDB($r);
$spe = $_SESSION['perfil'];
$idusuario = $_SESSION['userid'];
roleaccess(110);
include $r."inc/head.php"; ?>

<body class="fixed-nav sticky-footer sidenav-toggled bg-dark" id="page-top">
    <?php include $r."inc/nav.php"; ?>
 
    <div class="content-wrapper">
        <div class="container-fluid">
          <!-- Example DataTables Card-->
          <div class="card mb-3">
            <div class="h3 card-header">
              <i class="fa fa-table"></i> <?= $titlepage; ?>
              <? if(viewroleaccess(101)){ ?><a class="btn text-primary float-right p-0 ml-3" onclick="NewEmpresa()" title="Nuevo usuario"><i class="fa fa-plus-circle fa-2x"></i></a><? } ?>
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <table class="table table-bordered table-striped" id="dataTable" width="100%" cellspacing="0">
                  <thead>
                    <tr>
                      <th>ID</th>
                      <th>Logo</th>
                      <th>Empresa</th>
                      <th>Direccion</th>
                      <th>Telefono</th>
                      <th>Correo</th>
                      <th style="max-width: 120px;"><i class="fa fa-gear"></i></th>
                    </tr>
                  </thead>
                  <tfoot>
                    <tr>
                      <th>ID</th>
                      <th>Logo</th>
                      <th>Empresa</th>
                      <th>Direccion</th>
                      <th>Telefono</th>
                      <th>Correo</th>
                      <th style="max-width: 120px;"><i class="fa fa-gear"></i></th>
                    </tr>
                  </tfoot>
                  <tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
    </div>
      
  
    <!-- Modal Nuevo-->
    <div class="modal fade" id="ModalNewEmpresa" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="ModalNewEmpresaTitle"></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <form id="newformulario" action="acciones_empresas.php" method="POST" >
                
              <input type="hidden" name="ActionEmpresa">
              <div class="form-group">
                  <label>Logo</label>
                  <img src="uploads/load_logo.png" id="logo-preview" style="cursor: pointer;" width="50%">
                  <input type="file" name="logo" id="logo-file" class="form-control" style="display: none;" accept="image/*" required>
              </div>
              <div class="form-group">
                <label>Nombre Empresa</label>
                <input type="text" name="empresa" class="form-control" placeholder="Nombre Empresa" required>
              </div>
              <div class="form-group">
                <label>Direccion</label>
                <input type="text" name="direccion" class="form-control" placeholder="Direccion" required>
              </div>
              <div class="form-group">
                <label>Telefono</label>
                <input type="text" name="telefono" class="form-control" placeholder="Telefono" required>
              </div>
              <div class="form-group">
                <label>Correo Electronico</label>
                <input type="text" name="correo" class="form-control" placeholder="Correo electronico" required>
              </div>
            </form>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRAR</button>
            <button type="submit" form="newformulario" class="btn btn-primary">GUARDAR</button>
          </div>
        </div>
      </div>
    </div>
  <?php include $r."inc/foot.php"; ?>
  <script>
    $('#dataTable').DataTable({
      "processing": true,
      "serverSide": true,
      "ajax": 'server_side/empresas.php',
      "paging": true,
      "ordering": false,
      "searching": true,
      "dom": 'frBtip', // Agrega B para los botones
      "buttons": [
        'copy', 'csv', 'excel', 'pdf', 'print'
        // Puedes agregar más botones según tus necesidades
      ],
      // Otras configuraciones...
    });
    function NewEmpresa(){
        $('#newformulario')[0].reset();
        $('#ModalNewEmpresa').modal('show');
        $('#ModalNewEmpresaTitle').html('NUEVA EMPRESA');
        $('#logo-preview').attr('src', 'uploads/load_logo.png');
    }
    
    function editar(id){
        $.post( "acciones_empresas.php", { infoempresa: id })
          .done(function( response ) {
            if (response.success) {
                $('#ModalNewEmpresa').modal('show');
                $('input[name=ActionEmpresa]').val(id);
                $('#logo-preview').attr('src', response.data.logo);
                $('input[name=empresa]').val(response.data.empresa);
                $('input[name=direccion]').val(response.data.direccion);
                $('input[name=telefono]').val(response.data.telefono);
                $('input[name=correo]').val(response.data.correo);
                $('#ModalUserTitle').html('EDITAR EMPRESA');
            } else {
                // Mostrar un mensaje de error en algún lugar del formulario
                $("#error-message").html(response.message);
            }
        });
        
    }
    
    function estado(element, id){
        $.post( "acciones.php", { estado: id })
          .done(function( response ) {
            if (response.success) {
                $("#dataTable").DataTable().ajax.reload();
                swal(response.message);
            } else {
                // Mostrar un mensaje de error en algún lugar del formulario
                swal(response.message);
            }
        });
    }
    
    function eliminar(id){
        swal({
          title: "¿Estás seguro?",
          text: "No podrás recuperar a este usuario.",
          type: "warning",
          showCancelButton: true,
          cancelButtonText: 'No',
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Sí, eliminar",
          closeOnConfirm: false
        },
        function(){
          swal("¡Eliminado!", "El usuario ha sido eliminado.", "success");
        });
    }
    function reset(id){
        swal({
          title: "¿Estás seguro?",
          text: "De restablecer la contraseña del usuario",
          type: "warning",
          showCancelButton: true,
          cancelButtonText: 'No',
          confirmButtonColor: "#DD6B55",
          confirmButtonText: "Si, Restablecer!",
          closeOnConfirm: false,
          html: false
        }, function(){
          swal("Deleted!",
          "Your imaginary file has been deleted.",
          "success");
});
    }
    $(document).ready(function(){
        //Formualario
        $('#newformulario').on('submit', function(e) {
            // Evita el comportamiento predeterminado de envío del formulario
            e.preventDefault();
            swal('Espere PORFAVOR');
            // Obtén los datos del formulario
            var formData = new FormData(this);
            
            // Realiza la solicitud Ajax
            $.ajax({
                type: $(this).attr('method'), // O el método que estés utilizando en tu formulario
                url: $(this).attr('action'), // La URL a la que quieres enviar los datos
                data: formData, // Los datos del formulario
                dataType: 'json',
                contentType: false, // Necesario para enviar archivos
                processData: false, // Necesario para enviar archivos
                success: function(response) {
                    // Maneja la respuesta del servidor si es necesario
                    if (response.success) {
                        $("#dataTable").DataTable().ajax.reload();
                        $('#ModalNewEmpresa').modal('hide');
                        $('#newformulario')[0].reset();
                        swal(response.message);
                    } else {
                        // Mostrar un mensaje de error en algún lugar del formulario
                        swal(response.message);
                    }
                },
                error: function(xhr, status, error) {
                    // Maneja cualquier error que pueda ocurrir durante la solicitud
                    console.error('Error en la solicitud:', error);
                }
            });
        });

    // Resto del código...
  });
  $(document).ready(function(){
    $('#logo-preview').on('click', function(){
        $('#logo-file').click();
    });

    $('#logo-file').on('change', function(){
        var file = this.files[0];
        if (file) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#logo-preview').attr('src', e.target.result);
            }
            reader.readAsDataURL(file);
        }
    });
});
  </script>
</body>
</html>   